/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.platform;

import io.github.ascopes.protobufmavenplugin.platform.FileUtils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public final class HostSystem {
    private final String operatingSystem;
    private final String cpuArchitecture;
    private final Path workingDirectory;
    private final Collection<Path> path;
    private final SortedSet<String> pathExt;

    @Inject
    public HostSystem() {
        this(System.getProperties(), System.getenv());
    }

    public HostSystem(Properties properties, Map<String, String> environmentVariables) {
        this.operatingSystem = properties.getProperty("os.name", "");
        this.cpuArchitecture = properties.getProperty("os.arch", "");
        this.workingDirectory = FileUtils.normalize(Path.of("", new String[0]));
        this.path = HostSystem.tokenizeFilePath(environmentVariables.getOrDefault("PATH", ""), paths -> paths.map(x$0 -> Path.of(x$0, new String[0])).map(FileUtils::normalize).distinct().filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toUnmodifiableList()));
        this.pathExt = HostSystem.tokenizeFilePath(environmentVariables.getOrDefault("PATHEXT", ""), extensions -> extensions.collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet(String::compareToIgnoreCase)), Collections::unmodifiableSortedSet)));
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getCpuArchitecture() {
        return this.cpuArchitecture;
    }

    public boolean isProbablyLinux() {
        return this.operatingSystem.toLowerCase(Locale.ROOT).startsWith("linux");
    }

    public boolean isProbablyMacOs() {
        return this.operatingSystem.toLowerCase(Locale.ROOT).startsWith("mac os");
    }

    public boolean isProbablyWindows() {
        return this.operatingSystem.toLowerCase(Locale.ROOT).startsWith("windows");
    }

    public boolean isProbablyAndroidTermux() {
        return this.isProbablyLinux() && this.getWorkingDirectory().toString().startsWith("/data/data/com.termux/");
    }

    public Path getWorkingDirectory() {
        return this.workingDirectory;
    }

    public Collection<Path> getSystemPath() {
        return this.path;
    }

    public SortedSet<String> getSystemPathExtensions() {
        return this.pathExt;
    }

    private static <T> T tokenizeFilePath(String rawValue, Function<Stream<String>, T> mapper) {
        try (Scanner scanner = new Scanner(rawValue).useDelimiter(File.pathSeparator);){
            Stream<String> stream = scanner.tokens().map(String::trim).filter(Predicate.not(String::isBlank));
            T t = mapper.apply(stream);
            return t;
        }
    }
}

