/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.source;

import io.github.ascopes.protobufmavenplugin.platform.Digests;
import io.github.ascopes.protobufmavenplugin.platform.FileUtils;
import io.github.ascopes.protobufmavenplugin.source.ImmutableProtoFileListing;
import io.github.ascopes.protobufmavenplugin.source.ProtoFileListing;
import io.github.ascopes.protobufmavenplugin.source.ProtoFilePredicates;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class ProtoArchiveExtractor {
    private static final Logger log = LoggerFactory.getLogger(ProtoArchiveExtractor.class);
    private final Path extractionBaseDir;

    @Inject
    public ProtoArchiveExtractor(MavenProject mavenProject) {
        this.extractionBaseDir = Path.of(mavenProject.getBuild().getDirectory(), new String[0]).resolve("protobuf-maven-plugin").resolve("extracted");
    }

    public Optional<ProtoFileListing> extractProtoFiles(Path zipPath) throws IOException {
        try (FileSystem vfs = FileUtils.getFileSystemProvider("jar").newFileSystem(zipPath, Map.of());){
            Path vfsRoot = vfs.getRootDirectories().iterator().next();
            Collection<Path> sourceFiles = this.findProtoFilesInArchive(vfsRoot);
            if (sourceFiles.isEmpty()) {
                Optional<ProtoFileListing> optional = Optional.empty();
                return optional;
            }
            String uniqueName = Digests.sha1(zipPath.getFileName().toString());
            Path extractionRoot = this.extractionBaseDir.resolve(uniqueName);
            Files.createDirectories(extractionRoot, new FileAttribute[0]);
            ArrayList<Path> targetFiles = new ArrayList<Path>();
            for (Path sourceFile : sourceFiles) {
                Path targetFile = FileUtils.changeRelativePath(extractionRoot, vfsRoot, sourceFile);
                log.debug("Copying {} to {}", (Object)sourceFile.toUri(), (Object)targetFile);
                Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                Files.copy(sourceFile, targetFile, new CopyOption[0]);
                targetFiles.add(targetFile);
            }
            ImmutableProtoFileListing listing = ImmutableProtoFileListing.builder().originalRoot(zipPath).protoFilesRoot(extractionRoot).protoFiles(targetFiles).build();
            Optional<ProtoFileListing> optional = Optional.of(listing);
            return optional;
        }
    }

    private Collection<Path> findProtoFilesInArchive(Path archiveRootPath) throws IOException {
        try (Stream<Path> stream = Files.walk(archiveRootPath, new FileVisitOption[0]);){
            Collection collection = stream.filter(ProtoFilePredicates::isProtoFile).peek(protoFile -> log.debug("Found proto file {} in archive {}", (Object)protoFile.toUri(), (Object)archiveRootPath)).collect(Collectors.toUnmodifiableList());
            return collection;
        }
    }
}

