/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.dependency;

import io.github.ascopes.protobufmavenplugin.dependency.ImmutableResolvedPlugin;
import io.github.ascopes.protobufmavenplugin.dependency.MavenDependencyPathResolver;
import io.github.ascopes.protobufmavenplugin.dependency.PlatformArtifactFactory;
import io.github.ascopes.protobufmavenplugin.dependency.ResolutionException;
import io.github.ascopes.protobufmavenplugin.dependency.ResolvedPlugin;
import io.github.ascopes.protobufmavenplugin.dependency.SystemPathBinaryResolver;
import io.github.ascopes.protobufmavenplugin.platform.FileUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.shared.transfer.artifact.ArtifactCoordinate;

@Named
public final class BinaryPluginResolver {
    private final MavenDependencyPathResolver mavenDependencyPathResolver;
    private final PlatformArtifactFactory platformDependencyFactory;
    private final SystemPathBinaryResolver systemPathResolver;

    @Inject
    public BinaryPluginResolver(MavenDependencyPathResolver mavenDependencyPathResolver, PlatformArtifactFactory platformDependencyFactory, SystemPathBinaryResolver systemPathResolver) {
        this.mavenDependencyPathResolver = mavenDependencyPathResolver;
        this.platformDependencyFactory = platformDependencyFactory;
        this.systemPathResolver = systemPathResolver;
    }

    public Collection<ResolvedPlugin> resolveMavenPlugins(MavenSession session, Collection<ArtifactCoordinate> plugins) throws ResolutionException {
        ArrayList<ResolvedPlugin> resolvedPlugins = new ArrayList<ResolvedPlugin>();
        for (ArtifactCoordinate plugin : plugins) {
            resolvedPlugins.add(this.resolveMavenPlugin(session, plugin));
        }
        return resolvedPlugins;
    }

    private ResolvedPlugin resolveMavenPlugin(MavenSession session, ArtifactCoordinate plugin) throws ResolutionException {
        ArtifactCoordinate coordinate = this.enrich(plugin);
        try {
            Path path = this.mavenDependencyPathResolver.resolveArtifact(session, coordinate);
            FileUtils.makeExecutable(path);
            return this.createResolvedPlugin(path);
        }
        catch (IOException ex) {
            throw new ResolutionException("Failed to set executable bit on protoc plugin", ex);
        }
    }

    public Collection<ResolvedPlugin> resolvePathPlugins(Collection<String> plugins) throws ResolutionException {
        ArrayList<ResolvedPlugin> resolvedPlugins = new ArrayList<ResolvedPlugin>();
        for (String plugin : plugins) {
            resolvedPlugins.add(this.resolvePathPlugin(plugin));
        }
        return resolvedPlugins;
    }

    private ResolvedPlugin resolvePathPlugin(String binaryName) throws ResolutionException {
        Path path = this.systemPathResolver.resolve(binaryName).orElseThrow(() -> new ResolutionException("No executable '" + binaryName + "' was found on the system path"));
        return this.createResolvedPlugin(path);
    }

    private ResolvedPlugin createResolvedPlugin(Path path) {
        return ImmutableResolvedPlugin.builder().id(UUID.randomUUID().toString()).path(path).build();
    }

    private ArtifactCoordinate enrich(ArtifactCoordinate coordinate) {
        String extension = coordinate.getExtension().equals("jar") ? null : coordinate.getExtension();
        return this.platformDependencyFactory.createArtifact(coordinate.getGroupId(), coordinate.getArtifactId(), coordinate.getVersion(), extension, coordinate.getClassifier());
    }
}

