/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.execute;

import io.github.ascopes.protobufmavenplugin.platform.Shlex;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class CommandLineExecutor {
    private static final Logger log = LoggerFactory.getLogger(CommandLineExecutor.class);

    @Inject
    public CommandLineExecutor() {
    }

    public boolean execute(List<String> args) throws IOException {
        log.info("Calling protoc with the following command line: {}", (Object)Shlex.quoteShellArgs(args));
        ProcessBuilder procBuilder = new ProcessBuilder(args);
        procBuilder.environment().putAll(System.getenv());
        procBuilder.inheritIO();
        try {
            long startTimeNs = System.nanoTime();
            Process proc = procBuilder.start();
            int exitCode = proc.waitFor();
            long elapsedTimeMs = CommandLineExecutor.ms(System.nanoTime() - startTimeNs);
            if (exitCode == 0) {
                log.info("Protoc completed after {}ms", (Object)elapsedTimeMs);
                return true;
            }
            log.error("Protoc returned exit code {} after {}ms", (Object)exitCode, (Object)elapsedTimeMs);
            return false;
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            InterruptedIOException newEx = new InterruptedIOException("Compilation was interrupted");
            newEx.initCause(ex);
            throw newEx;
        }
    }

    private static long ms(long ns) {
        return ns / 1000000L;
    }
}

