/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.generate;

import io.github.ascopes.protobufmavenplugin.dependency.BinaryPluginResolver;
import io.github.ascopes.protobufmavenplugin.dependency.JvmPluginResolver;
import io.github.ascopes.protobufmavenplugin.dependency.MavenDependencyPathResolver;
import io.github.ascopes.protobufmavenplugin.dependency.ProtocResolver;
import io.github.ascopes.protobufmavenplugin.dependency.ResolutionException;
import io.github.ascopes.protobufmavenplugin.dependency.ResolvedPlugin;
import io.github.ascopes.protobufmavenplugin.execute.ArgLineBuilder;
import io.github.ascopes.protobufmavenplugin.execute.CommandLineExecutor;
import io.github.ascopes.protobufmavenplugin.generate.GenerationRequest;
import io.github.ascopes.protobufmavenplugin.generate.SourceRootRegistrar;
import io.github.ascopes.protobufmavenplugin.source.ProtoFileListing;
import io.github.ascopes.protobufmavenplugin.source.ProtoSourceResolver;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class SourceCodeGenerator {
    private static final Logger log = LoggerFactory.getLogger(SourceCodeGenerator.class);
    private final MavenDependencyPathResolver mavenDependencyPathResolver;
    private final ProtocResolver protocResolver;
    private final BinaryPluginResolver binaryPluginResolver;
    private final JvmPluginResolver jvmPluginResolver;
    private final ProtoSourceResolver protoListingResolver;
    private final CommandLineExecutor commandLineExecutor;

    @Inject
    public SourceCodeGenerator(MavenDependencyPathResolver mavenDependencyPathResolver, ProtocResolver protocResolver, BinaryPluginResolver binaryPluginResolver, JvmPluginResolver jvmPluginResolver, ProtoSourceResolver protoListingResolver, CommandLineExecutor commandLineExecutor) {
        this.mavenDependencyPathResolver = mavenDependencyPathResolver;
        this.protocResolver = protocResolver;
        this.binaryPluginResolver = binaryPluginResolver;
        this.jvmPluginResolver = jvmPluginResolver;
        this.protoListingResolver = protoListingResolver;
        this.commandLineExecutor = commandLineExecutor;
    }

    public boolean generate(GenerationRequest request) throws ResolutionException, IOException {
        Path protocPath = this.discoverProtocPath(request);
        Collection<ResolvedPlugin> plugins = this.discoverPlugins(request);
        Collection<ProtoFileListing> importPaths = this.discoverImportPaths(request);
        Collection<ProtoFileListing> sourcePaths = this.discoverCompilableSources(request);
        if (sourcePaths.isEmpty()) {
            log.info("No protobuf sources found; nothing to do!");
            return true;
        }
        this.createOutputDirectories(request);
        ArgLineBuilder argLineBuilder = new ArgLineBuilder(protocPath).fatalWarnings(request.isFatalWarnings()).importPaths(importPaths.stream().map(ProtoFileListing::getProtoFilesRoot).collect(Collectors.toUnmodifiableSet())).importPaths(request.getSourceRoots()).plugins(plugins, request.getOutputDirectory());
        if (request.isJavaEnabled()) {
            argLineBuilder.javaOut(request.getOutputDirectory(), request.isLiteEnabled());
        }
        if (request.isKotlinEnabled()) {
            argLineBuilder.kotlinOut(request.getOutputDirectory(), request.isLiteEnabled());
        }
        Set<Path> sourceFiles = sourcePaths.stream().map(ProtoFileListing::getProtoFiles).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
        return this.commandLineExecutor.execute(argLineBuilder.compile(sourceFiles));
    }

    private Path discoverProtocPath(GenerationRequest request) throws ResolutionException {
        return this.protocResolver.resolve(request.getMavenSession(), request.getProtocVersion());
    }

    private Collection<ResolvedPlugin> discoverPlugins(GenerationRequest request) throws IOException, ResolutionException {
        Collection<ResolvedPlugin> binaryMavenPlugins = this.binaryPluginResolver.resolveMavenPlugins(request.getMavenSession(), request.getBinaryMavenPlugins());
        Collection<ResolvedPlugin> binaryPathPlugins = this.binaryPluginResolver.resolvePathPlugins(request.getBinaryPathPlugins());
        Collection<ResolvedPlugin> jvmMavenPlugins = this.jvmPluginResolver.resolveMavenPlugins(request.getMavenSession(), request.getJvmMavenPlugins());
        return SourceCodeGenerator.concat(binaryMavenPlugins, binaryPathPlugins, jvmMavenPlugins);
    }

    private Collection<ProtoFileListing> discoverImportPaths(GenerationRequest request) throws IOException, ResolutionException {
        MavenSession session = request.getMavenSession();
        log.debug("Finding importable protobuf sources from the classpath");
        Collection<Path> dependencyPaths = this.mavenDependencyPathResolver.resolveProjectDependencyPaths(session, request.getAllowedDependencyScopes());
        Collection<ProtoFileListing> inheritedDependencies = this.protoListingResolver.createProtoFileListings(dependencyPaths);
        Collection<ProtoFileListing> explicitDependencies = this.protoListingResolver.createProtoFileListings(request.getAdditionalImportPaths());
        return SourceCodeGenerator.concat(inheritedDependencies, explicitDependencies);
    }

    private Collection<ProtoFileListing> discoverCompilableSources(GenerationRequest request) throws IOException {
        log.debug("Discovering all compilable protobuf source files");
        Collection<ProtoFileListing> sources = this.protoListingResolver.createProtoFileListings(request.getSourceRoots());
        log.info("Will generate source code for {} protobuf file(s)", (Object)sources.size());
        return sources;
    }

    private void createOutputDirectories(GenerationRequest request) throws IOException {
        Path directory = request.getOutputDirectory();
        SourceRootRegistrar registrar = request.getSourceRootRegistrar();
        log.info("Creating {} and registering as a {} root", (Object)directory, (Object)registrar);
        Files.createDirectories(directory, new FileAttribute[0]);
        registrar.registerSourceRoot(request.getMavenSession(), directory);
    }

    @SafeVarargs
    private static <T> List<T> concat(Collection<T> ... collections) {
        ArrayList<T> list = new ArrayList<T>();
        for (Collection<T> collection : collections) {
            list.addAll(collection);
        }
        return list;
    }
}

