/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.generate;

import java.nio.file.Path;
import java.util.function.BiConsumer;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.MavenProject;

@FunctionalInterface
public interface SourceRootRegistrar {
    public static final MavenRegistrar MAIN = new MavenRegistrar("main", MavenProject::addCompileSourceRoot);
    public static final MavenRegistrar TEST = new MavenRegistrar("test", MavenProject::addTestCompileSourceRoot);

    public void registerSourceRoot(MavenSession var1, Path var2);

    public static final class MavenRegistrar
    implements SourceRootRegistrar {
        private final String name;
        private final BiConsumer<MavenProject, String> delegate;

        private MavenRegistrar(String name, BiConsumer<MavenProject, String> delegate) {
            this.name = name;
            this.delegate = delegate;
        }

        @Override
        public void registerSourceRoot(MavenSession session, Path path) {
            this.delegate.accept(session.getCurrentProject(), path.toString());
        }

        public String toString() {
            return "Maven " + this.name;
        }
    }
}

