/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.protoc;

import io.github.ascopes.protobufmavenplugin.dependencies.ImmutableMavenDependency;
import io.github.ascopes.protobufmavenplugin.dependencies.PlatformClassifierFactory;
import io.github.ascopes.protobufmavenplugin.dependencies.ResolutionException;
import io.github.ascopes.protobufmavenplugin.dependencies.SystemPathBinaryResolver;
import io.github.ascopes.protobufmavenplugin.dependencies.UrlResourceFetcher;
import io.github.ascopes.protobufmavenplugin.dependencies.aether.AetherMavenArtifactPathResolver;
import io.github.ascopes.protobufmavenplugin.utils.FileUtils;
import io.github.ascopes.protobufmavenplugin.utils.HostSystem;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class ProtocResolver {
    private static final String EXECUTABLE_NAME = "protoc";
    private static final String GROUP_ID = "com.google.protobuf";
    private static final String ARTIFACT_ID = "protoc";
    private static final Logger log = LoggerFactory.getLogger(ProtocResolver.class);
    private final HostSystem hostSystem;
    private final AetherMavenArtifactPathResolver artifactPathResolver;
    private final PlatformClassifierFactory platformClassifierFactory;
    private final SystemPathBinaryResolver systemPathResolver;
    private final UrlResourceFetcher urlResourceFetcher;

    @Inject
    public ProtocResolver(HostSystem hostSystem, AetherMavenArtifactPathResolver artifactPathResolver, PlatformClassifierFactory platformClassifierFactory, SystemPathBinaryResolver systemPathResolver, UrlResourceFetcher urlResourceFetcher) {
        this.hostSystem = hostSystem;
        this.artifactPathResolver = artifactPathResolver;
        this.platformClassifierFactory = platformClassifierFactory;
        this.systemPathResolver = systemPathResolver;
        this.urlResourceFetcher = urlResourceFetcher;
    }

    public Optional<Path> resolve(String version) throws ResolutionException {
        Optional<Path> path;
        if (version.equalsIgnoreCase("latest")) {
            throw new IllegalArgumentException("Cannot use LATEST for the protobuf.compiler.version. Google has not released linear versions in the past, meaning that using LATEST will have unexpected behaviour.");
        }
        if (version.equalsIgnoreCase("PATH")) {
            return this.systemPathResolver.resolve("protoc");
        }
        Optional<Path> optional = path = version.contains(":") ? this.resolveFromUrl(version) : this.resolveFromMavenRepositories(version);
        if (path.isPresent()) {
            try {
                FileUtils.makeExecutable(path.get());
            }
            catch (IOException ex) {
                throw new ResolutionException("Failed to set executable bit on protoc binary", ex);
            }
        }
        return path;
    }

    private Optional<Path> resolveFromUrl(String url) throws ResolutionException {
        try {
            return this.urlResourceFetcher.fetchFileFromUrl(new URL(url), ".exe");
        }
        catch (IOException ex) {
            throw new ResolutionException(ex.getMessage(), ex);
        }
    }

    private Optional<Path> resolveFromMavenRepositories(String version) throws ResolutionException {
        if (this.hostSystem.isProbablyAndroid()) {
            log.warn("It looks like you are using Android! Android is known to be missing system calls for Linux that the official protoc binaries rely on to work. If you encounter issues, run Maven again with the -Dprotobuf.compiler.version=PATH flag to rerun with the version of protoc that is on your $PATH.");
        }
        ImmutableMavenDependency artifact = ImmutableMavenDependency.builder().groupId(GROUP_ID).artifactId("protoc").version(version).type("exe").classifier(this.platformClassifierFactory.getClassifier("protoc")).build();
        return Optional.of(this.artifactPathResolver.resolveArtifact(artifact));
    }
}

