/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.protoc;

import io.github.ascopes.protobufmavenplugin.protoc.OutputRedirectorDaemon;
import io.github.ascopes.protobufmavenplugin.utils.ArgumentFileBuilder;
import io.github.ascopes.protobufmavenplugin.utils.TeeWriter;
import io.github.ascopes.protobufmavenplugin.utils.TemporarySpace;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
public final class CommandLineExecutor {
    private static final Logger log = LoggerFactory.getLogger(CommandLineExecutor.class);
    private final TemporarySpace temporarySpace;

    @Inject
    public CommandLineExecutor(TemporarySpace temporarySpace) {
        this.temporarySpace = temporarySpace;
    }

    public boolean execute(Path protocPath, ArgumentFileBuilder argumentFileBuilder) throws IOException {
        Path argumentFile = this.writeArgumentFile(argumentFileBuilder);
        log.info("Invoking protoc (enable debug logs for more details)");
        log.debug("Protoc binary is located at {}", (Object)protocPath);
        log.debug("Protoc argument file:\n{},", (Object)argumentFileBuilder);
        ProcessBuilder procBuilder = new ProcessBuilder(protocPath.toString(), "@" + String.valueOf(argumentFile));
        procBuilder.environment().putAll(System.getenv());
        try {
            return this.runProcess(procBuilder);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            InterruptedIOException newEx = new InterruptedIOException("Execution was interrupted");
            newEx.initCause(ex);
            throw newEx;
        }
    }

    private Path writeArgumentFile(ArgumentFileBuilder argumentFileBuilder) throws IOException {
        TeeWriter writer;
        Path file = this.temporarySpace.createTemporarySpace("protoc").resolve("args.txt");
        log.debug("Writing to protoc argument file at {}", (Object)file);
        try (TeeWriter teeWriter = writer = new TeeWriter(Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]));){
            argumentFileBuilder.writeToProtocArgumentFile(writer);
        }
        log.debug("Written arguments were:\n{}", (Object)writer);
        return file;
    }

    private boolean runProcess(ProcessBuilder procBuilder) throws InterruptedException, IOException {
        long startTimeNs = System.nanoTime();
        log.trace("Starting protoc subprocess");
        Process proc = procBuilder.start();
        OutputRedirectorDaemon stdoutRedirector = new OutputRedirectorDaemon("protoc - stdout", proc.pid(), proc.getInputStream(), (arg_0, arg_1) -> ((Logger)log).info(arg_0, arg_1));
        OutputRedirectorDaemon stderrRedirector = new OutputRedirectorDaemon("protoc - stderr", proc.pid(), proc.getErrorStream(), (arg_0, arg_1) -> ((Logger)log).warn(arg_0, arg_1));
        log.trace("Waiting for protoc to exit...");
        int exitCode = proc.waitFor();
        long elapsedTimeMs = (System.nanoTime() - startTimeNs) / 1000000L;
        log.trace("Waiting for stdout and stderr redirectors to terminate...");
        stdoutRedirector.await();
        stderrRedirector.await();
        log.trace("Stdout and stderr redirectors terminated");
        if (exitCode == 0) {
            log.info("protoc (pid {}) returned exit code 0 (success) after {}ms", (Object)proc.pid(), (Object)elapsedTimeMs);
            return true;
        }
        log.error("protoc (pid {}) returned exit code {} (error) after {}ms", new Object[]{proc.pid(), exitCode, elapsedTimeMs});
        return false;
    }
}

