/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.sources.incremental;

import io.github.ascopes.protobufmavenplugin.sources.incremental.IncrementalCache;
import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="IncrementalCache", generator="Immutables")
final class ImmutableIncrementalCache
implements IncrementalCache {
    private final Map<Path, String> dependencies;
    private final Map<Path, String> sources;

    private ImmutableIncrementalCache(Builder builder) {
        this.dependencies = builder.dependencies == null ? Collections.emptyMap() : ImmutableIncrementalCache.createUnmodifiableMap(false, false, builder.dependencies);
        this.sources = builder.sources == null ? Collections.emptyMap() : ImmutableIncrementalCache.createUnmodifiableMap(false, false, builder.sources);
    }

    @Override
    public Map<Path, String> getDependencies() {
        return this.dependencies;
    }

    @Override
    public Map<Path, String> getSources() {
        return this.sources;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIncrementalCache && this.equalTo(0, (ImmutableIncrementalCache)another);
    }

    private boolean equalTo(int synthetic, ImmutableIncrementalCache another) {
        return this.dependencies.equals(another.dependencies) && this.sources.equals(another.sources);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.dependencies.hashCode();
        h += (h << 5) + this.sources.hashCode();
        return h;
    }

    public String toString() {
        return "IncrementalCache{dependencies=" + String.valueOf(this.dependencies) + ", sources=" + String.valueOf(this.sources) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="IncrementalCache", generator="Immutables")
    public static final class Builder {
        private Map<Path, String> dependencies = null;
        private Map<Path, String> sources = null;

        private Builder() {
        }

        public final Builder from(IncrementalCache instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllDependencies(instance.getDependencies());
            this.putAllSources(instance.getSources());
            return this;
        }

        public final Builder putDependencies(Path key, String value) {
            if (this.dependencies == null) {
                this.dependencies = new LinkedHashMap<Path, String>();
            }
            this.dependencies.put(key, value);
            return this;
        }

        public final Builder putDependencies(Map.Entry<? extends Path, ? extends String> entry) {
            if (this.dependencies == null) {
                this.dependencies = new LinkedHashMap<Path, String>();
            }
            Path k = entry.getKey();
            String v = entry.getValue();
            this.dependencies.put(k, v);
            return this;
        }

        public final Builder dependencies(Map<? extends Path, ? extends String> entries) {
            this.dependencies = new LinkedHashMap<Path, String>();
            return this.putAllDependencies(entries);
        }

        public final Builder putAllDependencies(Map<? extends Path, ? extends String> entries) {
            if (this.dependencies == null) {
                this.dependencies = new LinkedHashMap<Path, String>();
            }
            for (Map.Entry<? extends Path, ? extends String> e : entries.entrySet()) {
                Path k = e.getKey();
                String v = e.getValue();
                this.dependencies.put(k, v);
            }
            return this;
        }

        public final Builder putSources(Path key, String value) {
            if (this.sources == null) {
                this.sources = new LinkedHashMap<Path, String>();
            }
            this.sources.put(key, value);
            return this;
        }

        public final Builder putSources(Map.Entry<? extends Path, ? extends String> entry) {
            if (this.sources == null) {
                this.sources = new LinkedHashMap<Path, String>();
            }
            Path k = entry.getKey();
            String v = entry.getValue();
            this.sources.put(k, v);
            return this;
        }

        public final Builder sources(Map<? extends Path, ? extends String> entries) {
            this.sources = new LinkedHashMap<Path, String>();
            return this.putAllSources(entries);
        }

        public final Builder putAllSources(Map<? extends Path, ? extends String> entries) {
            if (this.sources == null) {
                this.sources = new LinkedHashMap<Path, String>();
            }
            for (Map.Entry<? extends Path, ? extends String> e : entries.entrySet()) {
                Path k = e.getKey();
                String v = e.getValue();
                this.sources.put(k, v);
            }
            return this;
        }

        public ImmutableIncrementalCache build() {
            return new ImmutableIncrementalCache(this);
        }
    }
}

