/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.plugins;

import io.github.ascopes.protobufmavenplugin.generation.GenerationRequest;
import io.github.ascopes.protobufmavenplugin.plugins.BinaryPluginResolver;
import io.github.ascopes.protobufmavenplugin.plugins.JvmPluginResolver;
import io.github.ascopes.protobufmavenplugin.plugins.ResolvedProtocPlugin;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import java.util.Collection;
import java.util.Comparator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public final class ProjectPluginResolver {
    private final BinaryPluginResolver binaryPluginResolver;
    private final JvmPluginResolver jvmPluginResolver;

    @Inject
    public ProjectPluginResolver(BinaryPluginResolver binaryPluginResolver, JvmPluginResolver jvmPluginResolver) {
        this.binaryPluginResolver = binaryPluginResolver;
        this.jvmPluginResolver = jvmPluginResolver;
    }

    public Collection<ResolvedProtocPlugin> resolveProjectPlugins(GenerationRequest request) throws ResolutionException {
        return Stream.builder().add(this.binaryPluginResolver.resolveMavenPlugins(request.getBinaryMavenPlugins())).add(this.binaryPluginResolver.resolvePathPlugins(request.getBinaryPathPlugins())).add(this.binaryPluginResolver.resolveUrlPlugins(request.getBinaryUrlPlugins())).add(this.jvmPluginResolver.resolveMavenPlugins(request.getJvmMavenPlugins())).build().flatMap(Collection::stream).sorted(Comparator.comparingInt(ResolvedProtocPlugin::getOrder)).collect(Collectors.toUnmodifiableList());
    }
}

