/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.urls;

import io.github.ascopes.protobufmavenplugin.urls.UrlFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.List;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

abstract class AbstractRecursiveUrlStreamHandlerFactory
implements URLStreamHandlerFactory {
    private final List<String> protocols;
    private final boolean archive;
    private final UrlFactory urlFactory;
    private final DecoratingUrlStreamHandlerImpl streamHandler;

    AbstractRecursiveUrlStreamHandlerFactory(boolean archive, UrlFactory urlFactory, String ... protocols) {
        if (protocols.length == 0) {
            throw new IllegalStateException("At least one protocol is required");
        }
        this.protocols = List.of(protocols);
        this.archive = archive;
        this.urlFactory = urlFactory;
        this.streamHandler = new DecoratingUrlStreamHandlerImpl();
    }

    @Override
    public final @Nullable URLStreamHandler createURLStreamHandler(String protocol) {
        return this.protocols.contains(protocol) ? this.streamHandler : null;
    }

    protected abstract InputStream decorate(InputStream var1, @Nullable String var2) throws IOException;

    private final class DecoratingUrlStreamHandlerImpl
    extends URLStreamHandler {
        private DecoratingUrlStreamHandlerImpl() {
        }

        @Override
        protected URLConnection openConnection(URL url) throws IOException {
            String rawInnerUri = url.getFile();
            String file = null;
            if (AbstractRecursiveUrlStreamHandlerFactory.this.archive) {
                int pathIndex = rawInnerUri.lastIndexOf("!/");
                if (pathIndex == -1) {
                    throw new IOException("URI '" + String.valueOf(url) + "' was missing a nested path fragment (e.g. '" + url.getProtocol() + ":http://some-website.com/some-file!/path/within/archive')");
                }
                file = rawInnerUri.substring(pathIndex + 2);
                rawInnerUri = rawInnerUri.substring(0, pathIndex);
            }
            URL innerUrl = AbstractRecursiveUrlStreamHandlerFactory.this.urlFactory.create(URI.create(rawInnerUri));
            return new DecoratingUrlConnection(url, innerUrl, file);
        }
    }

    private final class DecoratingUrlConnection
    extends URLConnection {
        private final URL innerUrl;
        private final @Nullable String file;
        private @Nullable URLConnection connection;
        private @Nullable InputStream decoratedInputStream;

        DecoratingUrlConnection(URL url, @Nullable URL innerUrl, String file) {
            super(url);
            this.innerUrl = innerUrl;
            this.file = file;
            this.connection = null;
            this.decoratedInputStream = null;
        }

        @Override
        public void connect() throws IOException {
            if (this.connected) {
                return;
            }
            this.connection = this.innerUrl.openConnection();
            this.connection.setAllowUserInteraction(this.getAllowUserInteraction());
            this.connection.setConnectTimeout(this.getConnectTimeout());
            this.connection.setDoInput(this.getDoInput());
            this.connection.setDoOutput(this.getDoOutput());
            this.connection.setIfModifiedSince(this.getIfModifiedSince());
            this.connection.setReadTimeout(this.getReadTimeout());
            this.connection.setUseCaches(this.getUseCaches());
            this.getRequestProperties().forEach((key, values) -> values.forEach(value -> this.connection.addRequestProperty((String)key, (String)value)));
            this.connection.connect();
            this.connected = true;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            if (this.decoratedInputStream == null) {
                URLConnection connection = Objects.requireNonNull(this.connection, "not connected");
                try {
                    this.decoratedInputStream = AbstractRecursiveUrlStreamHandlerFactory.this.decorate(connection.getInputStream(), this.file);
                }
                catch (IOException ex) {
                    connection.getInputStream().close();
                    throw new IOException("Failed to wrap input stream with protocol " + AbstractRecursiveUrlStreamHandlerFactory.this.protocols.iterator().next() + " for URL \"" + String.valueOf(this.url) + "\": " + String.valueOf(ex), ex);
                }
            }
            return this.decoratedInputStream;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return Objects.requireNonNull(this.connection, "not connected").getOutputStream();
        }
    }
}

