/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.urls;

import io.github.ascopes.protobufmavenplugin.urls.AbstractRecursiveUrlStreamHandlerFactory;
import io.github.ascopes.protobufmavenplugin.urls.InputStreamDecorator;
import io.github.ascopes.protobufmavenplugin.urls.UrlFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ArchiveUrlStreamHandlerFactory
extends AbstractRecursiveUrlStreamHandlerFactory {
    private static final Logger log = LoggerFactory.getLogger(ArchiveUrlStreamHandlerFactory.class);
    private final InputStreamDecorator<ArchiveInputStream<?>> decorator;

    ArchiveUrlStreamHandlerFactory(UrlFactory urlFactory, InputStreamDecorator<ArchiveInputStream<?>> decorator, String ... protocols) {
        super(true, urlFactory, protocols);
        this.decorator = decorator;
    }

    @Override
    protected InputStream decorate(InputStream inputStream, @Nullable String file) throws IOException {
        Objects.requireNonNull(file);
        file = ArchiveUrlStreamHandlerFactory.normalizeEntryName(file);
        try (InputStream inputStream2 = inputStream;){
            ByteArrayInputStream byteArrayInputStream;
            block14: {
                ArchiveInputStream<?> archiveInputStream = this.decorator.decorate(inputStream);
                try {
                    ArchiveEntry entry;
                    while ((entry = archiveInputStream.getNextEntry()) != null) {
                        String name = ArchiveUrlStreamHandlerFactory.normalizeEntryName(entry.getName());
                        log.trace("Discovered entry '{}' (original name was '{}') in {} (wrapping {})", new Object[]{name, entry.getName(), archiveInputStream, inputStream});
                        if (!file.equals(name)) continue;
                    }
                    if (entry == null) {
                        throw new FileNotFoundException("Could not find '" + file + "' within " + archiveInputStream.getClass().getSimpleName());
                    }
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    log.trace("Loading '{}' into new buffer", (Object)file);
                    archiveInputStream.transferTo((OutputStream)baos);
                    byteArrayInputStream = new ByteArrayInputStream(baos.toByteArray());
                    if (archiveInputStream == null) break block14;
                }
                catch (Throwable throwable) {
                    if (archiveInputStream != null) {
                        try {
                            archiveInputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                archiveInputStream.close();
            }
            return byteArrayInputStream;
        }
    }

    private static String normalizeEntryName(String name) {
        if (name.startsWith("./")) {
            name = name.substring(2);
        }
        return name;
    }
}

