/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.sources;

import io.github.ascopes.protobufmavenplugin.sources.DescriptorListing;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;

@Generated(from="DescriptorListing", generator="Immutables")
public final class ImmutableDescriptorListing
implements DescriptorListing {
    private final Path descriptorFilePath;
    private final Set<String> sourceFiles;

    private ImmutableDescriptorListing(Builder builder) {
        this.descriptorFilePath = builder.descriptorFilePath;
        this.sourceFiles = builder.sourceFiles == null ? Collections.emptySet() : ImmutableDescriptorListing.createUnmodifiableSet(builder.sourceFiles);
    }

    @Override
    public Path getDescriptorFilePath() {
        return this.descriptorFilePath;
    }

    @Override
    public Set<String> getSourceFiles() {
        return this.sourceFiles;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDescriptorListing && this.equalTo(0, (ImmutableDescriptorListing)another);
    }

    private boolean equalTo(int synthetic, ImmutableDescriptorListing another) {
        return Objects.equals(this.descriptorFilePath, another.descriptorFilePath) && this.sourceFiles.equals(another.sourceFiles);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.descriptorFilePath);
        h += (h << 5) + this.sourceFiles.hashCode();
        return h;
    }

    public String toString() {
        return "DescriptorListing{descriptorFilePath=" + String.valueOf(this.descriptorFilePath) + ", sourceFiles=" + String.valueOf(this.sourceFiles) + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Generated(from="DescriptorListing", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_DESCRIPTOR_FILE_PATH = 1L;
        private long initBits = 1L;
        private Path descriptorFilePath;
        private List<String> sourceFiles = null;

        private Builder() {
        }

        public final Builder from(DescriptorListing instance) {
            Objects.requireNonNull(instance, "instance");
            Path descriptorFilePathValue = instance.getDescriptorFilePath();
            if (descriptorFilePathValue != null) {
                this.descriptorFilePath(descriptorFilePathValue);
            }
            this.addAllSourceFiles(instance.getSourceFiles());
            return this;
        }

        public final Builder descriptorFilePath(Path descriptorFilePath) {
            this.descriptorFilePath = descriptorFilePath;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addSourceFiles(String element) {
            if (this.sourceFiles == null) {
                this.sourceFiles = new ArrayList<String>();
            }
            this.sourceFiles.add(element);
            return this;
        }

        public final Builder addSourceFiles(String ... elements) {
            if (this.sourceFiles == null) {
                this.sourceFiles = new ArrayList<String>();
            }
            for (String element : elements) {
                this.sourceFiles.add(element);
            }
            return this;
        }

        public final Builder sourceFiles(Iterable<String> elements) {
            this.sourceFiles = new ArrayList<String>();
            return this.addAllSourceFiles(elements);
        }

        public final Builder addAllSourceFiles(Iterable<String> elements) {
            Objects.requireNonNull(elements, "sourceFiles element");
            if (this.sourceFiles == null) {
                this.sourceFiles = new ArrayList<String>();
            }
            for (String element : elements) {
                this.sourceFiles.add(element);
            }
            return this;
        }

        public ImmutableDescriptorListing build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableDescriptorListing(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("descriptorFilePath");
            }
            return "Cannot build DescriptorListing, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

