/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.digests;

import io.github.ascopes.protobufmavenplugin.digests.Digest;
import java.security.Security;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.configurator.converters.basic.AbstractBasicConverter;

public final class DigestPlexusConverter
extends AbstractBasicConverter {
    private static final Pattern PATTERN = Pattern.compile("^(?<algorithm>[-a-z0-9]+):(?<digest>[0-9a-f]+)$", 2);
    private static final Map<String, String> DIGEST_ALIASES = Security.getAlgorithms("MessageDigest").stream().collect(Collectors.collectingAndThen(Collectors.toMap(Function.identity(), Function.identity(), (existingAlgorithm, newAlgorithm) -> newAlgorithm, () -> new TreeMap(Comparator.comparing(alias -> alias.replace("-", "").toLowerCase(Locale.ROOT)))), Collections::unmodifiableMap));

    public boolean canConvert(Class<?> type) {
        return Digest.class.equals(type);
    }

    protected Object fromString(String str) throws ComponentConfigurationException {
        Matcher matcher = PATTERN.matcher(str = DigestPlexusConverter.removeWhitespace(str));
        if (!matcher.matches()) {
            throw new ComponentConfigurationException("Failed to parse digest '" + str + "'. Ensure that the digest is in a format such as 'sha512:1a2b3c4d', where the digest is a hexadecimal-encoded string.");
        }
        try {
            String algorithm = matcher.group("algorithm");
            algorithm = DIGEST_ALIASES.getOrDefault(algorithm, algorithm);
            String digest = matcher.group("digest");
            return Digest.from(algorithm, digest);
        }
        catch (Exception ex) {
            throw new ComponentConfigurationException("Failed to parse digest '" + str + "': " + String.valueOf(ex), (Throwable)ex);
        }
    }

    private static String removeWhitespace(String string) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isWhitespace(c)) continue;
            sb.append(c);
        }
        return sb.toString();
    }
}

