/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.utils;

import io.github.ascopes.protobufmavenplugin.utils.MultipleFailuresException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.eclipse.sisu.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Manages an execution-wide thread pool for concurrent task execution")
@MojoExecutionScoped
@Named
public final class ConcurrentExecutor {
    private static int DEFAULT_MAXIMUM_CONCURRENCY = 80;
    private static int DEFAULT_MINIMUM_CONCURRENCY = 4;
    private static int DEFAULT_CONCURRENCY_MULTIPLIER = 8;
    private static final String CONCURRENCY_PROPERTY = "protobuf.executor.maxThreads";
    private static final Logger log = LoggerFactory.getLogger(ConcurrentExecutor.class);
    final ExecutorService executorService;

    @Inject
    public ConcurrentExecutor() {
        Runtime runtime = Runtime.getRuntime();
        int concurrency = ConcurrentExecutor.determineConcurrency(runtime.availableProcessors());
        this.executorService = Executors.newWorkStealingPool(concurrency);
    }

    @PreDestroy
    public void destroy() {
        log.debug("Shutting down executor...");
        List<Runnable> remainingTasks = this.executorService.shutdownNow();
        log.debug("Remaining tasks that will be orphaned: {}", remainingTasks);
    }

    public <R> FutureTask<R> submit(Callable<R> task) {
        FutureTask<R> futureTask = new FutureTask<R>(task);
        this.executorService.submit(futureTask);
        return futureTask;
    }

    public <R> Collector<FutureTask<R>, ?, List<R>> awaiting() {
        return Collectors.collectingAndThen(Collectors.toUnmodifiableList(), this::await);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> List<R> await(List<FutureTask<R>> scheduledTasks) {
        try {
            ArrayList<R> results = new ArrayList<R>();
            ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
            for (FutureTask<R> task : scheduledTasks) {
                try {
                    results.add(task.get());
                }
                catch (ExecutionException ex) {
                    exceptions.add(ex.getCause());
                }
                catch (InterruptedException | CancellationException ex) {
                    exceptions.add(ex);
                    break;
                }
            }
            if (!exceptions.isEmpty()) {
                throw MultipleFailuresException.create(exceptions);
            }
            List list = Collections.unmodifiableList(results);
            return list;
        }
        finally {
            for (FutureTask<R> task : scheduledTasks) {
                task.cancel(true);
            }
        }
    }

    static int determineConcurrency(int cpuCount) {
        int defaultConcurrency = Math.min(Math.max(DEFAULT_CONCURRENCY_MULTIPLIER * cpuCount, DEFAULT_MINIMUM_CONCURRENCY), DEFAULT_MAXIMUM_CONCURRENCY);
        Integer concurrency = Integer.getInteger(CONCURRENCY_PROPERTY, defaultConcurrency);
        if (concurrency < 1) {
            log.warn("Concurrency has been overridden to an invalid value ({}). This will be ignored and a concurrency of {} will be used instead.", (Object)concurrency, (Object)DEFAULT_MINIMUM_CONCURRENCY);
            concurrency = DEFAULT_MINIMUM_CONCURRENCY;
        }
        log.debug("Effective concurrency is {}, default concurrency is {}. Override this by passing -D{}=value", new Object[]{concurrency, defaultConcurrency, CONCURRENCY_PROPERTY});
        return concurrency;
    }
}

