/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.generation;

import io.github.ascopes.protobufmavenplugin.dependencies.DependencyResolutionDepth;
import io.github.ascopes.protobufmavenplugin.dependencies.MavenArtifact;
import io.github.ascopes.protobufmavenplugin.digests.Digest;
import io.github.ascopes.protobufmavenplugin.generation.GenerationRequest;
import io.github.ascopes.protobufmavenplugin.generation.Language;
import io.github.ascopes.protobufmavenplugin.generation.OutputDescriptorAttachmentRegistrar;
import io.github.ascopes.protobufmavenplugin.generation.SourceRootRegistrar;
import io.github.ascopes.protobufmavenplugin.plugins.MavenProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.PathProtocPlugin;
import io.github.ascopes.protobufmavenplugin.plugins.UriProtocPlugin;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.immutables.value.Generated;
import org.jspecify.annotations.Nullable;

@Generated(from="GenerationRequest", generator="Immutables")
public final class ImmutableGenerationRequest
implements GenerationRequest {
    private final List<String> arguments;
    private final @Nullable Collection<? extends MavenProtocPlugin> binaryMavenPlugins;
    private final @Nullable Collection<? extends PathProtocPlugin> binaryPathPlugins;
    private final @Nullable Collection<? extends UriProtocPlugin> binaryUrlPlugins;
    private final @Nullable DependencyResolutionDepth dependencyResolutionDepth;
    private final Set<String> dependencyScopes;
    private final @Nullable Collection<Language> enabledLanguages;
    private final List<String> excludes;
    private final Map<String, String> environmentVariables;
    private final @Nullable Collection<? extends MavenArtifact> importDependencies;
    private final @Nullable Collection<Path> importPaths;
    private final List<String> includes;
    private final @Nullable Collection<? extends MavenProtocPlugin> jvmMavenPlugins;
    private final @Nullable Path outputDirectory;
    private final @Nullable Path outputDescriptorFile;
    private final boolean outputDescriptorAttached;
    private final @Nullable String outputDescriptorAttachmentType;
    private final @Nullable String outputDescriptorAttachmentClassifier;
    private final @Nullable Digest protocDigest;
    private final @Nullable String protocVersion;
    private final @Nullable Path sanctionedExecutablePath;
    private final @Nullable Collection<? extends MavenArtifact> sourceDependencies;
    private final @Nullable Collection<? extends MavenArtifact> sourceDescriptorDependencies;
    private final @Nullable Collection<Path> sourceDescriptorPaths;
    private final @Nullable Collection<Path> sourceDirectories;
    private final @Nullable SourceRootRegistrar sourceRootRegistrar;
    private final @Nullable OutputDescriptorAttachmentRegistrar outputDescriptorAttachmentRegistrar;
    private final boolean cleanOutputDirectories;
    private final boolean embedSourcesInClassOutputs;
    private final boolean failOnMissingSources;
    private final boolean failOnMissingTargets;
    private final boolean fatalWarnings;
    private final boolean ignoreProjectDependencies;
    private final boolean incrementalCompilationEnabled;
    private final boolean liteEnabled;
    private final boolean outputDescriptorIncludeImports;
    private final boolean outputDescriptorIncludeSourceInfo;
    private final boolean outputDescriptorRetainOptions;
    private final boolean registerAsCompilationRoot;

    private ImmutableGenerationRequest(Builder builder) {
        this.arguments = builder.arguments == null ? Collections.emptyList() : ImmutableGenerationRequest.createUnmodifiableList(true, builder.arguments);
        this.binaryMavenPlugins = builder.binaryMavenPlugins;
        this.binaryPathPlugins = builder.binaryPathPlugins;
        this.binaryUrlPlugins = builder.binaryUrlPlugins;
        this.dependencyResolutionDepth = builder.dependencyResolutionDepth;
        this.dependencyScopes = builder.dependencyScopes == null ? Collections.emptySet() : ImmutableGenerationRequest.createUnmodifiableSet(builder.dependencyScopes);
        this.enabledLanguages = builder.enabledLanguages;
        this.excludes = builder.excludes == null ? Collections.emptyList() : ImmutableGenerationRequest.createUnmodifiableList(true, builder.excludes);
        this.environmentVariables = builder.environmentVariables == null ? Collections.emptyMap() : ImmutableGenerationRequest.createUnmodifiableMap(false, false, builder.environmentVariables);
        this.importDependencies = builder.importDependencies;
        this.importPaths = builder.importPaths;
        this.includes = builder.includes == null ? Collections.emptyList() : ImmutableGenerationRequest.createUnmodifiableList(true, builder.includes);
        this.jvmMavenPlugins = builder.jvmMavenPlugins;
        this.outputDirectory = builder.outputDirectory;
        this.outputDescriptorFile = builder.outputDescriptorFile;
        this.outputDescriptorAttached = builder.outputDescriptorAttached;
        this.outputDescriptorAttachmentType = builder.outputDescriptorAttachmentType;
        this.outputDescriptorAttachmentClassifier = builder.outputDescriptorAttachmentClassifier;
        this.protocDigest = builder.protocDigest;
        this.protocVersion = builder.protocVersion;
        this.sanctionedExecutablePath = builder.sanctionedExecutablePath;
        this.sourceDependencies = builder.sourceDependencies;
        this.sourceDescriptorDependencies = builder.sourceDescriptorDependencies;
        this.sourceDescriptorPaths = builder.sourceDescriptorPaths;
        this.sourceDirectories = builder.sourceDirectories;
        this.sourceRootRegistrar = builder.sourceRootRegistrar;
        this.outputDescriptorAttachmentRegistrar = builder.outputDescriptorAttachmentRegistrar;
        this.cleanOutputDirectories = builder.cleanOutputDirectories;
        this.embedSourcesInClassOutputs = builder.embedSourcesInClassOutputs;
        this.failOnMissingSources = builder.failOnMissingSources;
        this.failOnMissingTargets = builder.failOnMissingTargets;
        this.fatalWarnings = builder.fatalWarnings;
        this.ignoreProjectDependencies = builder.ignoreProjectDependencies;
        this.incrementalCompilationEnabled = builder.incrementalCompilationEnabled;
        this.liteEnabled = builder.liteEnabled;
        this.outputDescriptorIncludeImports = builder.outputDescriptorIncludeImports;
        this.outputDescriptorIncludeSourceInfo = builder.outputDescriptorIncludeSourceInfo;
        this.outputDescriptorRetainOptions = builder.outputDescriptorRetainOptions;
        this.registerAsCompilationRoot = builder.registerAsCompilationRoot;
    }

    @Override
    public List<String> getArguments() {
        return this.arguments;
    }

    @Override
    public @Nullable Collection<? extends MavenProtocPlugin> getBinaryMavenPlugins() {
        return this.binaryMavenPlugins;
    }

    @Override
    public @Nullable Collection<? extends PathProtocPlugin> getBinaryPathPlugins() {
        return this.binaryPathPlugins;
    }

    @Override
    public @Nullable Collection<? extends UriProtocPlugin> getBinaryUrlPlugins() {
        return this.binaryUrlPlugins;
    }

    @Override
    public @Nullable DependencyResolutionDepth getDependencyResolutionDepth() {
        return this.dependencyResolutionDepth;
    }

    @Override
    public Set<String> getDependencyScopes() {
        return this.dependencyScopes;
    }

    @Override
    public @Nullable Collection<Language> getEnabledLanguages() {
        return this.enabledLanguages;
    }

    @Override
    public List<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    public @Nullable Collection<? extends MavenArtifact> getImportDependencies() {
        return this.importDependencies;
    }

    @Override
    public @Nullable Collection<Path> getImportPaths() {
        return this.importPaths;
    }

    @Override
    public List<String> getIncludes() {
        return this.includes;
    }

    @Override
    public @Nullable Collection<? extends MavenProtocPlugin> getJvmMavenPlugins() {
        return this.jvmMavenPlugins;
    }

    @Override
    public @Nullable Path getOutputDirectory() {
        return this.outputDirectory;
    }

    @Override
    public @Nullable Path getOutputDescriptorFile() {
        return this.outputDescriptorFile;
    }

    @Override
    public boolean isOutputDescriptorAttached() {
        return this.outputDescriptorAttached;
    }

    @Override
    public @Nullable String getOutputDescriptorAttachmentType() {
        return this.outputDescriptorAttachmentType;
    }

    @Override
    public @Nullable String getOutputDescriptorAttachmentClassifier() {
        return this.outputDescriptorAttachmentClassifier;
    }

    @Override
    public @Nullable Digest getProtocDigest() {
        return this.protocDigest;
    }

    @Override
    public @Nullable String getProtocVersion() {
        return this.protocVersion;
    }

    @Override
    public @Nullable Path getSanctionedExecutablePath() {
        return this.sanctionedExecutablePath;
    }

    @Override
    public @Nullable Collection<? extends MavenArtifact> getSourceDependencies() {
        return this.sourceDependencies;
    }

    @Override
    public @Nullable Collection<? extends MavenArtifact> getSourceDescriptorDependencies() {
        return this.sourceDescriptorDependencies;
    }

    @Override
    public @Nullable Collection<Path> getSourceDescriptorPaths() {
        return this.sourceDescriptorPaths;
    }

    @Override
    public @Nullable Collection<Path> getSourceDirectories() {
        return this.sourceDirectories;
    }

    @Override
    public @Nullable SourceRootRegistrar getSourceRootRegistrar() {
        return this.sourceRootRegistrar;
    }

    @Override
    public @Nullable OutputDescriptorAttachmentRegistrar getOutputDescriptorAttachmentRegistrar() {
        return this.outputDescriptorAttachmentRegistrar;
    }

    @Override
    public boolean isCleanOutputDirectories() {
        return this.cleanOutputDirectories;
    }

    @Override
    public boolean isEmbedSourcesInClassOutputs() {
        return this.embedSourcesInClassOutputs;
    }

    @Override
    public boolean isFailOnMissingSources() {
        return this.failOnMissingSources;
    }

    @Override
    public boolean isFailOnMissingTargets() {
        return this.failOnMissingTargets;
    }

    @Override
    public boolean isFatalWarnings() {
        return this.fatalWarnings;
    }

    @Override
    public boolean isIgnoreProjectDependencies() {
        return this.ignoreProjectDependencies;
    }

    @Override
    public boolean isIncrementalCompilationEnabled() {
        return this.incrementalCompilationEnabled;
    }

    @Override
    public boolean isLiteEnabled() {
        return this.liteEnabled;
    }

    @Override
    public boolean isOutputDescriptorIncludeImports() {
        return this.outputDescriptorIncludeImports;
    }

    @Override
    public boolean isOutputDescriptorIncludeSourceInfo() {
        return this.outputDescriptorIncludeSourceInfo;
    }

    @Override
    public boolean isOutputDescriptorRetainOptions() {
        return this.outputDescriptorRetainOptions;
    }

    @Override
    public boolean isRegisterAsCompilationRoot() {
        return this.registerAsCompilationRoot;
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGenerationRequest && this.equalsByValue((ImmutableGenerationRequest)another);
    }

    private boolean equalsByValue(ImmutableGenerationRequest another) {
        return this.arguments.equals(another.arguments) && Objects.equals(this.binaryMavenPlugins, another.binaryMavenPlugins) && Objects.equals(this.binaryPathPlugins, another.binaryPathPlugins) && Objects.equals(this.binaryUrlPlugins, another.binaryUrlPlugins) && Objects.equals((Object)this.dependencyResolutionDepth, (Object)another.dependencyResolutionDepth) && this.dependencyScopes.equals(another.dependencyScopes) && Objects.equals(this.enabledLanguages, another.enabledLanguages) && this.excludes.equals(another.excludes) && this.environmentVariables.equals(another.environmentVariables) && Objects.equals(this.importDependencies, another.importDependencies) && Objects.equals(this.importPaths, another.importPaths) && this.includes.equals(another.includes) && Objects.equals(this.jvmMavenPlugins, another.jvmMavenPlugins) && Objects.equals(this.outputDirectory, another.outputDirectory) && Objects.equals(this.outputDescriptorFile, another.outputDescriptorFile) && this.outputDescriptorAttached == another.outputDescriptorAttached && Objects.equals(this.outputDescriptorAttachmentType, another.outputDescriptorAttachmentType) && Objects.equals(this.outputDescriptorAttachmentClassifier, another.outputDescriptorAttachmentClassifier) && Objects.equals(this.protocDigest, another.protocDigest) && Objects.equals(this.protocVersion, another.protocVersion) && Objects.equals(this.sanctionedExecutablePath, another.sanctionedExecutablePath) && Objects.equals(this.sourceDependencies, another.sourceDependencies) && Objects.equals(this.sourceDescriptorDependencies, another.sourceDescriptorDependencies) && Objects.equals(this.sourceDescriptorPaths, another.sourceDescriptorPaths) && Objects.equals(this.sourceDirectories, another.sourceDirectories) && Objects.equals(this.sourceRootRegistrar, another.sourceRootRegistrar) && Objects.equals(this.outputDescriptorAttachmentRegistrar, another.outputDescriptorAttachmentRegistrar) && this.cleanOutputDirectories == another.cleanOutputDirectories && this.embedSourcesInClassOutputs == another.embedSourcesInClassOutputs && this.failOnMissingSources == another.failOnMissingSources && this.failOnMissingTargets == another.failOnMissingTargets && this.fatalWarnings == another.fatalWarnings && this.ignoreProjectDependencies == another.ignoreProjectDependencies && this.incrementalCompilationEnabled == another.incrementalCompilationEnabled && this.liteEnabled == another.liteEnabled && this.outputDescriptorIncludeImports == another.outputDescriptorIncludeImports && this.outputDescriptorIncludeSourceInfo == another.outputDescriptorIncludeSourceInfo && this.outputDescriptorRetainOptions == another.outputDescriptorRetainOptions && this.registerAsCompilationRoot == another.registerAsCompilationRoot;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.arguments.hashCode();
        h += (h << 5) + Objects.hashCode(this.binaryMavenPlugins);
        h += (h << 5) + Objects.hashCode(this.binaryPathPlugins);
        h += (h << 5) + Objects.hashCode(this.binaryUrlPlugins);
        h += (h << 5) + Objects.hashCode((Object)this.dependencyResolutionDepth);
        h += (h << 5) + this.dependencyScopes.hashCode();
        h += (h << 5) + Objects.hashCode(this.enabledLanguages);
        h += (h << 5) + this.excludes.hashCode();
        h += (h << 5) + this.environmentVariables.hashCode();
        h += (h << 5) + Objects.hashCode(this.importDependencies);
        h += (h << 5) + Objects.hashCode(this.importPaths);
        h += (h << 5) + this.includes.hashCode();
        h += (h << 5) + Objects.hashCode(this.jvmMavenPlugins);
        h += (h << 5) + Objects.hashCode(this.outputDirectory);
        h += (h << 5) + Objects.hashCode(this.outputDescriptorFile);
        h += (h << 5) + Boolean.hashCode(this.outputDescriptorAttached);
        h += (h << 5) + Objects.hashCode(this.outputDescriptorAttachmentType);
        h += (h << 5) + Objects.hashCode(this.outputDescriptorAttachmentClassifier);
        h += (h << 5) + Objects.hashCode(this.protocDigest);
        h += (h << 5) + Objects.hashCode(this.protocVersion);
        h += (h << 5) + Objects.hashCode(this.sanctionedExecutablePath);
        h += (h << 5) + Objects.hashCode(this.sourceDependencies);
        h += (h << 5) + Objects.hashCode(this.sourceDescriptorDependencies);
        h += (h << 5) + Objects.hashCode(this.sourceDescriptorPaths);
        h += (h << 5) + Objects.hashCode(this.sourceDirectories);
        h += (h << 5) + Objects.hashCode(this.sourceRootRegistrar);
        h += (h << 5) + Objects.hashCode(this.outputDescriptorAttachmentRegistrar);
        h += (h << 5) + Boolean.hashCode(this.cleanOutputDirectories);
        h += (h << 5) + Boolean.hashCode(this.embedSourcesInClassOutputs);
        h += (h << 5) + Boolean.hashCode(this.failOnMissingSources);
        h += (h << 5) + Boolean.hashCode(this.failOnMissingTargets);
        h += (h << 5) + Boolean.hashCode(this.fatalWarnings);
        h += (h << 5) + Boolean.hashCode(this.ignoreProjectDependencies);
        h += (h << 5) + Boolean.hashCode(this.incrementalCompilationEnabled);
        h += (h << 5) + Boolean.hashCode(this.liteEnabled);
        h += (h << 5) + Boolean.hashCode(this.outputDescriptorIncludeImports);
        h += (h << 5) + Boolean.hashCode(this.outputDescriptorIncludeSourceInfo);
        h += (h << 5) + Boolean.hashCode(this.outputDescriptorRetainOptions);
        h += (h << 5) + Boolean.hashCode(this.registerAsCompilationRoot);
        return h;
    }

    public String toString() {
        return "GenerationRequest{arguments=" + String.valueOf(this.arguments) + ", binaryMavenPlugins=" + String.valueOf(this.binaryMavenPlugins) + ", binaryPathPlugins=" + String.valueOf(this.binaryPathPlugins) + ", binaryUrlPlugins=" + String.valueOf(this.binaryUrlPlugins) + ", dependencyResolutionDepth=" + String.valueOf((Object)this.dependencyResolutionDepth) + ", dependencyScopes=" + String.valueOf(this.dependencyScopes) + ", enabledLanguages=" + String.valueOf(this.enabledLanguages) + ", excludes=" + String.valueOf(this.excludes) + ", environmentVariables=" + String.valueOf(this.environmentVariables) + ", importDependencies=" + String.valueOf(this.importDependencies) + ", importPaths=" + String.valueOf(this.importPaths) + ", includes=" + String.valueOf(this.includes) + ", jvmMavenPlugins=" + String.valueOf(this.jvmMavenPlugins) + ", outputDirectory=" + String.valueOf(this.outputDirectory) + ", outputDescriptorFile=" + String.valueOf(this.outputDescriptorFile) + ", outputDescriptorAttached=" + this.outputDescriptorAttached + ", outputDescriptorAttachmentType=" + this.outputDescriptorAttachmentType + ", outputDescriptorAttachmentClassifier=" + this.outputDescriptorAttachmentClassifier + ", protocDigest=" + String.valueOf(this.protocDigest) + ", protocVersion=" + this.protocVersion + ", sanctionedExecutablePath=" + String.valueOf(this.sanctionedExecutablePath) + ", sourceDependencies=" + String.valueOf(this.sourceDependencies) + ", sourceDescriptorDependencies=" + String.valueOf(this.sourceDescriptorDependencies) + ", sourceDescriptorPaths=" + String.valueOf(this.sourceDescriptorPaths) + ", sourceDirectories=" + String.valueOf(this.sourceDirectories) + ", sourceRootRegistrar=" + String.valueOf(this.sourceRootRegistrar) + ", outputDescriptorAttachmentRegistrar=" + String.valueOf(this.outputDescriptorAttachmentRegistrar) + ", cleanOutputDirectories=" + this.cleanOutputDirectories + ", embedSourcesInClassOutputs=" + this.embedSourcesInClassOutputs + ", failOnMissingSources=" + this.failOnMissingSources + ", failOnMissingTargets=" + this.failOnMissingTargets + ", fatalWarnings=" + this.fatalWarnings + ", ignoreProjectDependencies=" + this.ignoreProjectDependencies + ", incrementalCompilationEnabled=" + this.incrementalCompilationEnabled + ", liteEnabled=" + this.liteEnabled + ", outputDescriptorIncludeImports=" + this.outputDescriptorIncludeImports + ", outputDescriptorIncludeSourceInfo=" + this.outputDescriptorIncludeSourceInfo + ", outputDescriptorRetainOptions=" + this.outputDescriptorRetainOptions + ", registerAsCompilationRoot=" + this.registerAsCompilationRoot + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <T> Set<T> createUnmodifiableSet(List<? extends T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + String.valueOf(k) : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @Generated(from="GenerationRequest", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_BINARY_MAVEN_PLUGINS = 1L;
        private static final long INIT_BIT_BINARY_PATH_PLUGINS = 2L;
        private static final long INIT_BIT_BINARY_URL_PLUGINS = 4L;
        private static final long INIT_BIT_DEPENDENCY_RESOLUTION_DEPTH = 8L;
        private static final long INIT_BIT_ENABLED_LANGUAGES = 16L;
        private static final long INIT_BIT_IMPORT_DEPENDENCIES = 32L;
        private static final long INIT_BIT_IMPORT_PATHS = 64L;
        private static final long INIT_BIT_JVM_MAVEN_PLUGINS = 128L;
        private static final long INIT_BIT_OUTPUT_DIRECTORY = 256L;
        private static final long INIT_BIT_OUTPUT_DESCRIPTOR_ATTACHED = 512L;
        private static final long INIT_BIT_PROTOC_VERSION = 1024L;
        private static final long INIT_BIT_SOURCE_DEPENDENCIES = 2048L;
        private static final long INIT_BIT_SOURCE_DESCRIPTOR_DEPENDENCIES = 4096L;
        private static final long INIT_BIT_SOURCE_DESCRIPTOR_PATHS = 8192L;
        private static final long INIT_BIT_SOURCE_DIRECTORIES = 16384L;
        private static final long INIT_BIT_SOURCE_ROOT_REGISTRAR = 32768L;
        private static final long INIT_BIT_OUTPUT_DESCRIPTOR_ATTACHMENT_REGISTRAR = 65536L;
        private static final long INIT_BIT_CLEAN_OUTPUT_DIRECTORIES = 131072L;
        private static final long INIT_BIT_EMBED_SOURCES_IN_CLASS_OUTPUTS = 262144L;
        private static final long INIT_BIT_FAIL_ON_MISSING_SOURCES = 524288L;
        private static final long INIT_BIT_FAIL_ON_MISSING_TARGETS = 0x100000L;
        private static final long INIT_BIT_FATAL_WARNINGS = 0x200000L;
        private static final long INIT_BIT_IGNORE_PROJECT_DEPENDENCIES = 0x400000L;
        private static final long INIT_BIT_INCREMENTAL_COMPILATION_ENABLED = 0x800000L;
        private static final long INIT_BIT_LITE_ENABLED = 0x1000000L;
        private static final long INIT_BIT_OUTPUT_DESCRIPTOR_INCLUDE_IMPORTS = 0x2000000L;
        private static final long INIT_BIT_OUTPUT_DESCRIPTOR_INCLUDE_SOURCE_INFO = 0x4000000L;
        private static final long INIT_BIT_OUTPUT_DESCRIPTOR_RETAIN_OPTIONS = 0x8000000L;
        private static final long INIT_BIT_REGISTER_AS_COMPILATION_ROOT = 0x10000000L;
        private long initBits = 0x1FFFFFFFL;
        private @Nullable List<String> arguments = null;
        private @Nullable Collection<? extends MavenProtocPlugin> binaryMavenPlugins;
        private @Nullable Collection<? extends PathProtocPlugin> binaryPathPlugins;
        private @Nullable Collection<? extends UriProtocPlugin> binaryUrlPlugins;
        private @Nullable DependencyResolutionDepth dependencyResolutionDepth;
        private @Nullable List<String> dependencyScopes = null;
        private @Nullable Collection<Language> enabledLanguages;
        private @Nullable List<String> excludes = null;
        private @Nullable Map<String, String> environmentVariables = null;
        private @Nullable Collection<? extends MavenArtifact> importDependencies;
        private @Nullable Collection<Path> importPaths;
        private @Nullable List<String> includes = null;
        private @Nullable Collection<? extends MavenProtocPlugin> jvmMavenPlugins;
        private @Nullable Path outputDirectory;
        private @Nullable Path outputDescriptorFile;
        private boolean outputDescriptorAttached;
        private @Nullable String outputDescriptorAttachmentType;
        private @Nullable String outputDescriptorAttachmentClassifier;
        private @Nullable Digest protocDigest;
        private @Nullable String protocVersion;
        private @Nullable Path sanctionedExecutablePath;
        private @Nullable Collection<? extends MavenArtifact> sourceDependencies;
        private @Nullable Collection<? extends MavenArtifact> sourceDescriptorDependencies;
        private @Nullable Collection<Path> sourceDescriptorPaths;
        private @Nullable Collection<Path> sourceDirectories;
        private @Nullable SourceRootRegistrar sourceRootRegistrar;
        private @Nullable OutputDescriptorAttachmentRegistrar outputDescriptorAttachmentRegistrar;
        private boolean cleanOutputDirectories;
        private boolean embedSourcesInClassOutputs;
        private boolean failOnMissingSources;
        private boolean failOnMissingTargets;
        private boolean fatalWarnings;
        private boolean ignoreProjectDependencies;
        private boolean incrementalCompilationEnabled;
        private boolean liteEnabled;
        private boolean outputDescriptorIncludeImports;
        private boolean outputDescriptorIncludeSourceInfo;
        private boolean outputDescriptorRetainOptions;
        private boolean registerAsCompilationRoot;

        private Builder() {
        }

        public final Builder from(GenerationRequest instance) {
            OutputDescriptorAttachmentRegistrar outputDescriptorAttachmentRegistrarValue;
            SourceRootRegistrar sourceRootRegistrarValue;
            Collection<Path> sourceDirectoriesValue;
            Collection<Path> sourceDescriptorPathsValue;
            Collection<? extends MavenArtifact> sourceDescriptorDependenciesValue;
            Collection<? extends MavenArtifact> sourceDependenciesValue;
            Path sanctionedExecutablePathValue;
            String protocVersionValue;
            Digest protocDigestValue;
            String outputDescriptorAttachmentClassifierValue;
            Path outputDescriptorFileValue;
            Path outputDirectoryValue;
            Collection<Path> importPathsValue;
            DependencyResolutionDepth dependencyResolutionDepthValue;
            Collection<? extends UriProtocPlugin> binaryUrlPluginsValue;
            Collection<? extends PathProtocPlugin> binaryPathPluginsValue;
            Objects.requireNonNull(instance, "instance");
            this.addAllArguments(instance.getArguments());
            Collection<? extends MavenProtocPlugin> binaryMavenPluginsValue = instance.getBinaryMavenPlugins();
            if (binaryMavenPluginsValue != null) {
                this.binaryMavenPlugins(binaryMavenPluginsValue);
            }
            if ((binaryPathPluginsValue = instance.getBinaryPathPlugins()) != null) {
                this.binaryPathPlugins(binaryPathPluginsValue);
            }
            if ((binaryUrlPluginsValue = instance.getBinaryUrlPlugins()) != null) {
                this.binaryUrlPlugins(binaryUrlPluginsValue);
            }
            if ((dependencyResolutionDepthValue = instance.getDependencyResolutionDepth()) != null) {
                this.dependencyResolutionDepth(dependencyResolutionDepthValue);
            }
            this.addAllDependencyScopes(instance.getDependencyScopes());
            Collection<Language> enabledLanguagesValue = instance.getEnabledLanguages();
            if (enabledLanguagesValue != null) {
                this.enabledLanguages(enabledLanguagesValue);
            }
            this.addAllExcludes(instance.getExcludes());
            this.putAllEnvironmentVariables(instance.getEnvironmentVariables());
            Collection<? extends MavenArtifact> importDependenciesValue = instance.getImportDependencies();
            if (importDependenciesValue != null) {
                this.importDependencies(importDependenciesValue);
            }
            if ((importPathsValue = instance.getImportPaths()) != null) {
                this.importPaths(importPathsValue);
            }
            this.addAllIncludes(instance.getIncludes());
            Collection<? extends MavenProtocPlugin> jvmMavenPluginsValue = instance.getJvmMavenPlugins();
            if (jvmMavenPluginsValue != null) {
                this.jvmMavenPlugins(jvmMavenPluginsValue);
            }
            if ((outputDirectoryValue = instance.getOutputDirectory()) != null) {
                this.outputDirectory(outputDirectoryValue);
            }
            if ((outputDescriptorFileValue = instance.getOutputDescriptorFile()) != null) {
                this.outputDescriptorFile(outputDescriptorFileValue);
            }
            this.outputDescriptorAttached(instance.isOutputDescriptorAttached());
            @Nullable String outputDescriptorAttachmentTypeValue = instance.getOutputDescriptorAttachmentType();
            if (outputDescriptorAttachmentTypeValue != null) {
                this.outputDescriptorAttachmentType(outputDescriptorAttachmentTypeValue);
            }
            if ((outputDescriptorAttachmentClassifierValue = instance.getOutputDescriptorAttachmentClassifier()) != null) {
                this.outputDescriptorAttachmentClassifier(outputDescriptorAttachmentClassifierValue);
            }
            if ((protocDigestValue = instance.getProtocDigest()) != null) {
                this.protocDigest(protocDigestValue);
            }
            if ((protocVersionValue = instance.getProtocVersion()) != null) {
                this.protocVersion(protocVersionValue);
            }
            if ((sanctionedExecutablePathValue = instance.getSanctionedExecutablePath()) != null) {
                this.sanctionedExecutablePath(sanctionedExecutablePathValue);
            }
            if ((sourceDependenciesValue = instance.getSourceDependencies()) != null) {
                this.sourceDependencies(sourceDependenciesValue);
            }
            if ((sourceDescriptorDependenciesValue = instance.getSourceDescriptorDependencies()) != null) {
                this.sourceDescriptorDependencies(sourceDescriptorDependenciesValue);
            }
            if ((sourceDescriptorPathsValue = instance.getSourceDescriptorPaths()) != null) {
                this.sourceDescriptorPaths(sourceDescriptorPathsValue);
            }
            if ((sourceDirectoriesValue = instance.getSourceDirectories()) != null) {
                this.sourceDirectories(sourceDirectoriesValue);
            }
            if ((sourceRootRegistrarValue = instance.getSourceRootRegistrar()) != null) {
                this.sourceRootRegistrar(sourceRootRegistrarValue);
            }
            if ((outputDescriptorAttachmentRegistrarValue = instance.getOutputDescriptorAttachmentRegistrar()) != null) {
                this.outputDescriptorAttachmentRegistrar(outputDescriptorAttachmentRegistrarValue);
            }
            this.cleanOutputDirectories(instance.isCleanOutputDirectories());
            this.embedSourcesInClassOutputs(instance.isEmbedSourcesInClassOutputs());
            this.failOnMissingSources(instance.isFailOnMissingSources());
            this.failOnMissingTargets(instance.isFailOnMissingTargets());
            this.fatalWarnings(instance.isFatalWarnings());
            this.ignoreProjectDependencies(instance.isIgnoreProjectDependencies());
            this.incrementalCompilationEnabled(instance.isIncrementalCompilationEnabled());
            this.liteEnabled(instance.isLiteEnabled());
            this.outputDescriptorIncludeImports(instance.isOutputDescriptorIncludeImports());
            this.outputDescriptorIncludeSourceInfo(instance.isOutputDescriptorIncludeSourceInfo());
            this.outputDescriptorRetainOptions(instance.isOutputDescriptorRetainOptions());
            this.registerAsCompilationRoot(instance.isRegisterAsCompilationRoot());
            return this;
        }

        public final Builder addArguments(@Nullable String element) {
            if (this.arguments == null) {
                this.arguments = new ArrayList<String>();
            }
            this.arguments.add(element);
            return this;
        }

        public final Builder addArguments(String ... elements) {
            if (this.arguments == null) {
                this.arguments = new ArrayList<String>();
            }
            for (String element : elements) {
                this.arguments.add(element);
            }
            return this;
        }

        public final Builder arguments(Iterable<@Nullable String> elements) {
            this.arguments = new ArrayList<String>();
            return this.addAllArguments(elements);
        }

        public final Builder addAllArguments(Iterable<@Nullable String> elements) {
            Objects.requireNonNull(elements, "arguments element");
            if (this.arguments == null) {
                this.arguments = new ArrayList<String>();
            }
            for (String element : elements) {
                this.arguments.add(element);
            }
            return this;
        }

        public final Builder binaryMavenPlugins(Collection<? extends MavenProtocPlugin> binaryMavenPlugins) {
            this.binaryMavenPlugins = binaryMavenPlugins;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder binaryPathPlugins(Collection<? extends PathProtocPlugin> binaryPathPlugins) {
            this.binaryPathPlugins = binaryPathPlugins;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder binaryUrlPlugins(Collection<? extends UriProtocPlugin> binaryUrlPlugins) {
            this.binaryUrlPlugins = binaryUrlPlugins;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder dependencyResolutionDepth(DependencyResolutionDepth dependencyResolutionDepth) {
            this.dependencyResolutionDepth = dependencyResolutionDepth;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder addDependencyScopes(@Nullable String element) {
            if (this.dependencyScopes == null) {
                this.dependencyScopes = new ArrayList<String>();
            }
            this.dependencyScopes.add(element);
            return this;
        }

        public final Builder addDependencyScopes(String ... elements) {
            if (this.dependencyScopes == null) {
                this.dependencyScopes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.dependencyScopes.add(element);
            }
            return this;
        }

        public final Builder dependencyScopes(Iterable<@Nullable String> elements) {
            this.dependencyScopes = new ArrayList<String>();
            return this.addAllDependencyScopes(elements);
        }

        public final Builder addAllDependencyScopes(Iterable<@Nullable String> elements) {
            Objects.requireNonNull(elements, "dependencyScopes element");
            if (this.dependencyScopes == null) {
                this.dependencyScopes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.dependencyScopes.add(element);
            }
            return this;
        }

        public final Builder enabledLanguages(Collection<Language> enabledLanguages) {
            this.enabledLanguages = enabledLanguages;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder addExcludes(@Nullable String element) {
            if (this.excludes == null) {
                this.excludes = new ArrayList<String>();
            }
            this.excludes.add(element);
            return this;
        }

        public final Builder addExcludes(String ... elements) {
            if (this.excludes == null) {
                this.excludes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.excludes.add(element);
            }
            return this;
        }

        public final Builder excludes(Iterable<@Nullable String> elements) {
            this.excludes = new ArrayList<String>();
            return this.addAllExcludes(elements);
        }

        public final Builder addAllExcludes(Iterable<@Nullable String> elements) {
            Objects.requireNonNull(elements, "excludes element");
            if (this.excludes == null) {
                this.excludes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.excludes.add(element);
            }
            return this;
        }

        public final Builder putEnvironmentVariables(@Nullable String key, @Nullable String value) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, String>();
            }
            this.environmentVariables.put(key, value);
            return this;
        }

        public final Builder putEnvironmentVariables(Map.Entry<@Nullable String, ? extends @Nullable String> entry) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, String>();
            }
            String k = entry.getKey();
            @Nullable String v = entry.getValue();
            this.environmentVariables.put(k, v);
            return this;
        }

        public final Builder environmentVariables(Map<@Nullable String, ? extends @Nullable String> entries) {
            this.environmentVariables = new LinkedHashMap<String, String>();
            return this.putAllEnvironmentVariables(entries);
        }

        public final Builder putAllEnvironmentVariables(Map<@Nullable String, ? extends @Nullable String> entries) {
            if (this.environmentVariables == null) {
                this.environmentVariables = new LinkedHashMap<String, String>();
            }
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                @Nullable String v = e.getValue();
                this.environmentVariables.put(k, v);
            }
            return this;
        }

        public final Builder importDependencies(Collection<? extends MavenArtifact> importDependencies) {
            this.importDependencies = importDependencies;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder importPaths(Collection<Path> importPaths) {
            this.importPaths = importPaths;
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder addIncludes(@Nullable String element) {
            if (this.includes == null) {
                this.includes = new ArrayList<String>();
            }
            this.includes.add(element);
            return this;
        }

        public final Builder addIncludes(String ... elements) {
            if (this.includes == null) {
                this.includes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.includes.add(element);
            }
            return this;
        }

        public final Builder includes(Iterable<@Nullable String> elements) {
            this.includes = new ArrayList<String>();
            return this.addAllIncludes(elements);
        }

        public final Builder addAllIncludes(Iterable<@Nullable String> elements) {
            Objects.requireNonNull(elements, "includes element");
            if (this.includes == null) {
                this.includes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.includes.add(element);
            }
            return this;
        }

        public final Builder jvmMavenPlugins(Collection<? extends MavenProtocPlugin> jvmMavenPlugins) {
            this.jvmMavenPlugins = jvmMavenPlugins;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder outputDirectory(Path outputDirectory) {
            this.outputDirectory = outputDirectory;
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder outputDescriptorFile(@Nullable Path outputDescriptorFile) {
            this.outputDescriptorFile = outputDescriptorFile;
            return this;
        }

        public final Builder outputDescriptorAttached(boolean outputDescriptorAttached) {
            this.outputDescriptorAttached = outputDescriptorAttached;
            this.initBits &= 0xFFFFFFFFFFFFFDFFL;
            return this;
        }

        public final Builder outputDescriptorAttachmentType(@Nullable String outputDescriptorAttachmentType) {
            this.outputDescriptorAttachmentType = outputDescriptorAttachmentType;
            return this;
        }

        public final Builder outputDescriptorAttachmentClassifier(@Nullable String outputDescriptorAttachmentClassifier) {
            this.outputDescriptorAttachmentClassifier = outputDescriptorAttachmentClassifier;
            return this;
        }

        public final Builder protocDigest(@Nullable Digest protocDigest) {
            this.protocDigest = protocDigest;
            return this;
        }

        public final Builder protocVersion(String protocVersion) {
            this.protocVersion = protocVersion;
            this.initBits &= 0xFFFFFFFFFFFFFBFFL;
            return this;
        }

        public final Builder sanctionedExecutablePath(@Nullable Path sanctionedExecutablePath) {
            this.sanctionedExecutablePath = sanctionedExecutablePath;
            return this;
        }

        public final Builder sourceDependencies(Collection<? extends MavenArtifact> sourceDependencies) {
            this.sourceDependencies = sourceDependencies;
            this.initBits &= 0xFFFFFFFFFFFFF7FFL;
            return this;
        }

        public final Builder sourceDescriptorDependencies(Collection<? extends MavenArtifact> sourceDescriptorDependencies) {
            this.sourceDescriptorDependencies = sourceDescriptorDependencies;
            this.initBits &= 0xFFFFFFFFFFFFEFFFL;
            return this;
        }

        public final Builder sourceDescriptorPaths(Collection<Path> sourceDescriptorPaths) {
            this.sourceDescriptorPaths = sourceDescriptorPaths;
            this.initBits &= 0xFFFFFFFFFFFFDFFFL;
            return this;
        }

        public final Builder sourceDirectories(Collection<Path> sourceDirectories) {
            this.sourceDirectories = sourceDirectories;
            this.initBits &= 0xFFFFFFFFFFFFBFFFL;
            return this;
        }

        public final Builder sourceRootRegistrar(SourceRootRegistrar sourceRootRegistrar) {
            this.sourceRootRegistrar = sourceRootRegistrar;
            this.initBits &= 0xFFFFFFFFFFFF7FFFL;
            return this;
        }

        public final Builder outputDescriptorAttachmentRegistrar(OutputDescriptorAttachmentRegistrar outputDescriptorAttachmentRegistrar) {
            this.outputDescriptorAttachmentRegistrar = outputDescriptorAttachmentRegistrar;
            this.initBits &= 0xFFFFFFFFFFFEFFFFL;
            return this;
        }

        public final Builder cleanOutputDirectories(boolean cleanOutputDirectories) {
            this.cleanOutputDirectories = cleanOutputDirectories;
            this.initBits &= 0xFFFFFFFFFFFDFFFFL;
            return this;
        }

        public final Builder embedSourcesInClassOutputs(boolean embedSourcesInClassOutputs) {
            this.embedSourcesInClassOutputs = embedSourcesInClassOutputs;
            this.initBits &= 0xFFFFFFFFFFFBFFFFL;
            return this;
        }

        public final Builder failOnMissingSources(boolean failOnMissingSources) {
            this.failOnMissingSources = failOnMissingSources;
            this.initBits &= 0xFFFFFFFFFFF7FFFFL;
            return this;
        }

        public final Builder failOnMissingTargets(boolean failOnMissingTargets) {
            this.failOnMissingTargets = failOnMissingTargets;
            this.initBits &= 0xFFFFFFFFFFEFFFFFL;
            return this;
        }

        public final Builder fatalWarnings(boolean fatalWarnings) {
            this.fatalWarnings = fatalWarnings;
            this.initBits &= 0xFFFFFFFFFFDFFFFFL;
            return this;
        }

        public final Builder ignoreProjectDependencies(boolean ignoreProjectDependencies) {
            this.ignoreProjectDependencies = ignoreProjectDependencies;
            this.initBits &= 0xFFFFFFFFFFBFFFFFL;
            return this;
        }

        public final Builder incrementalCompilationEnabled(boolean incrementalCompilationEnabled) {
            this.incrementalCompilationEnabled = incrementalCompilationEnabled;
            this.initBits &= 0xFFFFFFFFFF7FFFFFL;
            return this;
        }

        public final Builder liteEnabled(boolean liteEnabled) {
            this.liteEnabled = liteEnabled;
            this.initBits &= 0xFFFFFFFFFEFFFFFFL;
            return this;
        }

        public final Builder outputDescriptorIncludeImports(boolean outputDescriptorIncludeImports) {
            this.outputDescriptorIncludeImports = outputDescriptorIncludeImports;
            this.initBits &= 0xFFFFFFFFFDFFFFFFL;
            return this;
        }

        public final Builder outputDescriptorIncludeSourceInfo(boolean outputDescriptorIncludeSourceInfo) {
            this.outputDescriptorIncludeSourceInfo = outputDescriptorIncludeSourceInfo;
            this.initBits &= 0xFFFFFFFFFBFFFFFFL;
            return this;
        }

        public final Builder outputDescriptorRetainOptions(boolean outputDescriptorRetainOptions) {
            this.outputDescriptorRetainOptions = outputDescriptorRetainOptions;
            this.initBits &= 0xFFFFFFFFF7FFFFFFL;
            return this;
        }

        public final Builder registerAsCompilationRoot(boolean registerAsCompilationRoot) {
            this.registerAsCompilationRoot = registerAsCompilationRoot;
            this.initBits &= 0xFFFFFFFFEFFFFFFFL;
            return this;
        }

        public ImmutableGenerationRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGenerationRequest(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("binaryMavenPlugins");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("binaryPathPlugins");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("binaryUrlPlugins");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("dependencyResolutionDepth");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("enabledLanguages");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("importDependencies");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("importPaths");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("jvmMavenPlugins");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("outputDirectory");
            }
            if ((this.initBits & 0x200L) != 0L) {
                attributes.add("outputDescriptorAttached");
            }
            if ((this.initBits & 0x400L) != 0L) {
                attributes.add("protocVersion");
            }
            if ((this.initBits & 0x800L) != 0L) {
                attributes.add("sourceDependencies");
            }
            if ((this.initBits & 0x1000L) != 0L) {
                attributes.add("sourceDescriptorDependencies");
            }
            if ((this.initBits & 0x2000L) != 0L) {
                attributes.add("sourceDescriptorPaths");
            }
            if ((this.initBits & 0x4000L) != 0L) {
                attributes.add("sourceDirectories");
            }
            if ((this.initBits & 0x8000L) != 0L) {
                attributes.add("sourceRootRegistrar");
            }
            if ((this.initBits & 0x10000L) != 0L) {
                attributes.add("outputDescriptorAttachmentRegistrar");
            }
            if ((this.initBits & 0x20000L) != 0L) {
                attributes.add("cleanOutputDirectories");
            }
            if ((this.initBits & 0x40000L) != 0L) {
                attributes.add("embedSourcesInClassOutputs");
            }
            if ((this.initBits & 0x80000L) != 0L) {
                attributes.add("failOnMissingSources");
            }
            if ((this.initBits & 0x100000L) != 0L) {
                attributes.add("failOnMissingTargets");
            }
            if ((this.initBits & 0x200000L) != 0L) {
                attributes.add("fatalWarnings");
            }
            if ((this.initBits & 0x400000L) != 0L) {
                attributes.add("ignoreProjectDependencies");
            }
            if ((this.initBits & 0x800000L) != 0L) {
                attributes.add("incrementalCompilationEnabled");
            }
            if ((this.initBits & 0x1000000L) != 0L) {
                attributes.add("liteEnabled");
            }
            if ((this.initBits & 0x2000000L) != 0L) {
                attributes.add("outputDescriptorIncludeImports");
            }
            if ((this.initBits & 0x4000000L) != 0L) {
                attributes.add("outputDescriptorIncludeSourceInfo");
            }
            if ((this.initBits & 0x8000000L) != 0L) {
                attributes.add("outputDescriptorRetainOptions");
            }
            if ((this.initBits & 0x10000000L) != 0L) {
                attributes.add("registerAsCompilationRoot");
            }
            return "Cannot build GenerationRequest, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

