/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.urls;

import io.github.ascopes.protobufmavenplugin.digests.Digest;
import io.github.ascopes.protobufmavenplugin.fs.FileUtils;
import io.github.ascopes.protobufmavenplugin.fs.TemporarySpace;
import io.github.ascopes.protobufmavenplugin.urls.UrlFactory;
import io.github.ascopes.protobufmavenplugin.utils.ResolutionException;
import io.github.ascopes.protobufmavenplugin.utils.StringUtils;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.Maven;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.eclipse.sisu.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Fetches and downloads resources from URIs")
@MojoExecutionScoped
@Named
public final class UriResourceFetcher {
    private static final Pattern OFFLINE_PROTOCOLS = Pattern.compile("^([A-Za-z0-9-]+:)*file:.*");
    private static final String USER_AGENT = String.format("protobuf-maven-plugin/%s (io.github.ascopes) Apache-Maven/%s Java/%s (%s, %s, %s)", UriResourceFetcher.class.getPackage().getImplementationVersion(), Maven.class.getPackage().getImplementationVersion(), System.getProperty("java.version"), System.getProperty("java.vm.name"), System.getProperty("java.vm.version"), System.getProperty("java.vm.vendor"));
    private static final int TIMEOUT = 30000;
    private static final Logger log = LoggerFactory.getLogger(UriResourceFetcher.class);
    private final MavenSession mavenSession;
    private final TemporarySpace temporarySpace;
    private final UrlFactory urlFactory;

    @Inject
    public UriResourceFetcher(MavenSession mavenSession, UrlFactory urlFactory, TemporarySpace temporarySpace) {
        this.mavenSession = mavenSession;
        this.temporarySpace = temporarySpace;
        this.urlFactory = urlFactory;
    }

    public Optional<Path> fetchFileFromUri(URI uri, String extension, boolean setExecutable) throws ResolutionException {
        if (this.mavenSession.isOffline() && !OFFLINE_PROTOCOLS.matcher(uri.toString()).matches()) {
            throw new ResolutionException("Cannot resolve URI \"" + String.valueOf(uri) + "\". Only a limited number of URL protocols are supported in offline mode.");
        }
        return this.fetchFileFromUriOnline(uri, extension, setExecutable);
    }

    private Optional<Path> fetchFileFromUriOnline(URI uri, String extension, boolean setExecutable) throws ResolutionException {
        URL url;
        try {
            url = this.urlFactory.create(uri);
        }
        catch (IOException ex) {
            throw new ResolutionException("URI \"" + String.valueOf(uri) + "\" is invalid: " + String.valueOf(ex), ex);
        }
        Path targetFile = this.targetFile(url, extension);
        try {
            URLConnection conn = UriResourceFetcher.openConnection(url);
            log.debug("Connecting to \"{}\", will transfer contents to \"{}\"", (Object)uri, (Object)targetFile);
            conn.connect();
            try (BufferedInputStream responseInputStream = new BufferedInputStream(conn.getInputStream());
                 OutputStream fileOutputStream = FileUtils.newBufferedOutputStream(targetFile, new OpenOption[0]);){
                responseInputStream.transferTo(fileOutputStream);
            }
            long fileSize = Files.size(targetFile);
            log.info("Transferred \"{}\" to \"{}\" ({})", new Object[]{uri, targetFile, StringUtils.pluralize(fileSize, "byte")});
            if (setExecutable) {
                FileUtils.makeExecutable(targetFile);
            }
            return Optional.of(targetFile);
        }
        catch (IOException ex) {
            log.debug("Failed to transfer \"{}\" to \"{}\"", new Object[]{uri, targetFile, ex});
            if (ex instanceof FileNotFoundException) {
                log.warn("No resource at \"{}\" exists", (Object)uri);
                return Optional.empty();
            }
            throw new ResolutionException("Failed to transfer \"" + String.valueOf(uri) + "\" to \"" + String.valueOf(targetFile) + "\": " + String.valueOf(ex), ex);
        }
    }

    private static URLConnection openConnection(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        conn.addRequestProperty("User-Agent", USER_AGENT);
        conn.setAllowUserInteraction(false);
        conn.setConnectTimeout(30000);
        conn.setDoInput(true);
        conn.setDoOutput(false);
        conn.setReadTimeout(30000);
        conn.setUseCaches(false);
        return conn;
    }

    private Path targetFile(URL url, String extension) {
        String digest = Digest.compute("SHA-1", url.toExternalForm()).toHexString();
        String path = url.getPath();
        int lastSlash = path.lastIndexOf(47);
        String fileName = lastSlash < 0 ? digest : path.substring(lastSlash + 1) + "-" + digest;
        return this.temporarySpace.createTemporarySpace("url", url.getProtocol()).resolve(fileName + extension);
    }
}

