/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.urls;

import io.github.ascopes.protobufmavenplugin.urls.ApacheArchiveUrlStreamHandlerFactory;
import io.github.ascopes.protobufmavenplugin.urls.HttpUrlStreamHandlerFactory;
import io.github.ascopes.protobufmavenplugin.urls.NestingUrlStreamHandlerFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.List;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import javax.annotation.PostConstruct;
import javax.inject.Named;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.jspecify.annotations.Nullable;

@MojoExecutionScoped
@Named
public final class UrlFactory {
    private @Nullable List<URLStreamHandlerFactory> urlStreamHandlerFactories;

    @PostConstruct
    void init() {
        this.urlStreamHandlerFactories = List.of(new NestingUrlStreamHandlerFactory(this, BZip2CompressorInputStream::new, "bz", "bz2", "bzip", "bzip2"), new NestingUrlStreamHandlerFactory(this, GZIPInputStream::new, "gz", "gzip"), new ApacheArchiveUrlStreamHandlerFactory(this, JarArchiveInputStream::new, "jar", "ear", "war"), new ApacheArchiveUrlStreamHandlerFactory(this, ZipArchiveInputStream::new, "kar", "zip"), new ApacheArchiveUrlStreamHandlerFactory(this, TarArchiveInputStream::new, "tar", new String[0]), new HttpUrlStreamHandlerFactory());
    }

    public URL create(URI uri) throws IOException {
        String protocol = uri.getScheme();
        URLStreamHandler handler = Objects.requireNonNull(this.urlStreamHandlerFactories).stream().map(factory -> factory.createURLStreamHandler(protocol)).filter(Objects::nonNull).findFirst().orElse(null);
        return new URL(null, uri.toString(), handler);
    }
}

