/*
 * Decompiled with CFR 0.152.
 */
package io.github.ascopes.protobufmavenplugin.urls;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

final class HttpRequestException
extends IOException {
    private final URI uri;
    private final int statusCode;
    private final @Nullable String correlationId;
    private final @Nullable String requestId;
    private final @Nullable String wwwAuthenticate;
    private final @Nullable String proxyAuthenticate;
    private final @Nullable String responseBody;

    HttpRequestException(URI uri, int statusCode, @Nullable String correlationId, @Nullable String requestId, @Nullable String wwwAuthenticate, @Nullable String proxyAuthenticate, @Nullable String responseBody) {
        this.uri = uri;
        this.statusCode = statusCode;
        this.correlationId = correlationId;
        this.requestId = requestId;
        this.wwwAuthenticate = wwwAuthenticate;
        this.proxyAuthenticate = proxyAuthenticate;
        this.responseBody = responseBody;
    }

    URI getUri() {
        return this.uri;
    }

    int getStatusCode() {
        return this.statusCode;
    }

    @Nullable String getCorrelationId() {
        return this.correlationId;
    }

    @Nullable String getRequestId() {
        return this.requestId;
    }

    @Nullable String getWwwAuthenticate() {
        return this.wwwAuthenticate;
    }

    @Nullable String getProxyAuthenticate() {
        return this.proxyAuthenticate;
    }

    @Nullable String getResponseBody() {
        return this.responseBody;
    }

    @Override
    public String getMessage() {
        return "An HTTP error occurred. Further details: uri='" + String.valueOf(this.uri) + "', statusCode=" + this.statusCode + ", correlationId='" + this.correlationId + "', requestId='" + this.requestId + "', wwwAuthenticate='" + this.wwwAuthenticate + "', proxyAuthenticate='" + this.proxyAuthenticate + "', responseBody='" + this.responseBody + "'";
    }

    static HttpRequestException fromHttpResponse(HttpResponse<InputStream> response) {
        String body = HttpRequestException.asText(response.body(), 500);
        String correlationId = HttpRequestException.extractHeader(response, "Correlation-Id", "X-Correlation-Id");
        String requestId = HttpRequestException.extractHeader(response, "Request-Id", "X-Request-Id");
        return new HttpRequestException(response.uri(), response.statusCode(), correlationId, requestId, HttpRequestException.extractHeader(response, "WWW-Authenticate"), HttpRequestException.extractHeader(response, "Proxy-Authenticate"), body);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static @Nullable String asText(InputStream stream, int maxLength) {
        if (stream == null) {
            return null;
        }
        try (InputStream inputStream = stream;){
            byte[] body = stream.readNBytes(maxLength + 1);
            String text = new String(body, StandardCharsets.UTF_8);
            if (text.length() > maxLength) {
                String string2 = text.substring(0, maxLength) + "... [truncated]";
                return string2;
            }
            String string = text;
            return string;
        }
        catch (Exception e) {
            return "<binary or unreadable response body>";
        }
    }

    private static @Nullable String extractHeader(HttpResponse<InputStream> response, String ... names) {
        for (String name : names) {
            Optional<String> val = response.headers().firstValue(name);
            if (!val.isPresent()) continue;
            return val.get();
        }
        return null;
    }
}

