/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.client;

import io.github.azagniotov.stubby4j.annotations.CoberturaIgnore;

public final class Authorization {
    private final AuthorizationType authorizationType;
    private final String value;

    public Authorization(AuthorizationType authorizationType, String value) {
        this.authorizationType = authorizationType;
        this.value = value;
    }

    @CoberturaIgnore
    public String asFullValue() {
        if (this.authorizationType == AuthorizationType.CUSTOM) {
            return this.value;
        }
        return String.format("%s %s", this.authorizationType.asString(), this.value);
    }

    @CoberturaIgnore
    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Authorization");
        sb.append("{type=").append((Object)this.authorizationType);
        sb.append(", value=").append(this.value);
        sb.append('}');
        return sb.toString();
    }

    static enum AuthorizationType {
        BASIC("Basic"),
        BEARER("Bearer"),
        CUSTOM("Custom");

        private final String type;

        private AuthorizationType(String type) {
            this.type = type;
        }

        public String asString() {
            return this.type;
        }
    }
}

