/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.handlers;

import io.github.azagniotov.stubby4j.cli.CommandLineInterpreter;
import io.github.azagniotov.stubby4j.database.StubbedDataManager;
import io.github.azagniotov.stubby4j.server.JettyContext;
import io.github.azagniotov.stubby4j.utils.ConsoleUtils;
import io.github.azagniotov.stubby4j.utils.HandlerUtils;
import io.github.azagniotov.stubby4j.utils.JarUtils;
import io.github.azagniotov.stubby4j.utils.ObjectUtils;
import io.github.azagniotov.stubby4j.utils.ReflectionUtils;
import io.github.azagniotov.stubby4j.utils.StringUtils;
import io.github.azagniotov.stubby4j.yaml.stubs.StubHttpLifecycle;
import io.github.azagniotov.stubby4j.yaml.stubs.StubResponse;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public final class StatusPageHandler
extends AbstractHandler {
    private static final RuntimeMXBean RUNTIME_MX_BEAN = ManagementFactory.getRuntimeMXBean();
    private static final MemoryMXBean MEMORY_MX_BEAN = ManagementFactory.getMemoryMXBean();
    private static final List<String> FIELDS_FOR_AJAX_LINKS = Collections.unmodifiableList(Arrays.asList("file", "body", "post"));
    private static final String TEMPLATE_LOADED_FILE_METADATA_PAIR = "<span style='color: #8B0000'>%s</span>=<span style='color: green'>%s</span>";
    private static final String TEMPLATE_AJAX_TO_RESOURCE_HYPERLINK = "<strong><a class='ajax-resource' href='/ajax/resource/%s/%s/%s'>[view]</a></strong>";
    private static final String TEMPLATE_AJAX_TO_STATS_HYPERLINK = "<strong><a class='ajax-stats' href='/ajax/stats'>[view]</a></strong>";
    private static final String TEMPLATE_HTML_TABLE_ROW = "<tr><td width='250px' valign='top' align='left'>%s</td><td align='left'>%s</td></tr>";
    private static final String TEMPLATE_HTML_TABLE = HandlerUtils.getHtmlResourceByName("_table");
    private static final String NEXT_IN_THE_QUEUE = " NEXT IN THE QUEUE";
    private final StubbedDataManager stubbedDataManager;
    private final JettyContext jettyContext;

    public StatusPageHandler(JettyContext newContext, StubbedDataManager newStubbedDataManager) {
        this.jettyContext = newContext;
        this.stubbedDataManager = newStubbedDataManager;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ConsoleUtils.logIncomingRequest(request);
        if (response.isCommitted() || baseRequest.isHandled()) {
            ConsoleUtils.logIncomingRequestError(request, "status", "HTTP response was committed or base request was handled, aborting..");
            return;
        }
        baseRequest.setHandled(true);
        response.setContentType("text/html;charset=UTF-8");
        response.setStatus(200);
        response.setHeader(HttpHeader.SERVER.asString().toLowerCase(), HandlerUtils.constructHeaderServerName());
        try {
            response.getWriter().println(this.buildStatusPageHtml());
        }
        catch (Exception ex) {
            HandlerUtils.configureErrorResponse(response, 500, ex.toString());
        }
        ConsoleUtils.logOutgoingResponse(request.getRequestURI(), response);
    }

    private String buildStatusPageHtml() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append(this.buildJvmParametersHtmlTable());
        builder.append(this.buildJettyParametersHtmlTable());
        builder.append(this.buildStubbyParametersHtmlTable());
        builder.append(this.buildEndpointStatsHtmlTable());
        List<StubHttpLifecycle> stubHttpLifecycles = this.stubbedDataManager.getStubHttpLifecycles();
        for (int cycleIndex = 0; cycleIndex < stubHttpLifecycles.size(); ++cycleIndex) {
            StubHttpLifecycle stubHttpLifecycle = stubHttpLifecycles.get(cycleIndex);
            builder.append(this.buildStubRequestHtmlTable(stubHttpLifecycle));
            builder.append(this.buildStubResponseHtmlTable(stubHttpLifecycle));
            builder.append("<br /><br />");
        }
        long timestamp = System.currentTimeMillis();
        return HandlerUtils.populateHtmlTemplate("status", timestamp, timestamp, builder.toString());
    }

    private String buildStubRequestHtmlTable(StubHttpLifecycle stubHttpLifecycle) throws Exception {
        String resourceId = stubHttpLifecycle.getResourceId();
        String ajaxLinkToRequestAsYaml = String.format(TEMPLATE_AJAX_TO_RESOURCE_HYPERLINK, resourceId, "httplifecycle", "requestAsYaml");
        StringBuilder requestTableBuilder = this.buildStubHtmlTableBody(resourceId, "request", ReflectionUtils.getProperties(stubHttpLifecycle.getRequest()));
        requestTableBuilder.append(this.interpolateHtmlTableRowTemplate("RAW YAML", ajaxLinkToRequestAsYaml));
        return String.format(TEMPLATE_HTML_TABLE, "request", requestTableBuilder.toString());
    }

    private String buildStubResponseHtmlTable(StubHttpLifecycle stubHttpLifecycle) throws Exception {
        String resourceId = stubHttpLifecycle.getResourceId();
        StringBuilder responseTableBuilder = new StringBuilder();
        List<StubResponse> allResponses = stubHttpLifecycle.getAllResponses();
        for (int sequenceId = 0; sequenceId < allResponses.size(); ++sequenceId) {
            boolean isResponsesSequenced = allResponses.size() != 1;
            int nextSequencedResponseId = stubHttpLifecycle.getNextSequencedResponseId();
            String nextResponseLabel = isResponsesSequenced && nextSequencedResponseId == sequenceId ? NEXT_IN_THE_QUEUE : "";
            String responseTableTitle = isResponsesSequenced ? String.format("%s/%s%s", "response", sequenceId, nextResponseLabel) : "response";
            StubResponse stubResponse = allResponses.get(sequenceId);
            Map<String, String> stubResponseProperties = ReflectionUtils.getProperties(stubResponse);
            StringBuilder sequencedResponseBuilder = this.buildStubHtmlTableBody(resourceId, responseTableTitle, stubResponseProperties);
            String ajaxLinkToResponseAsYaml = String.format(TEMPLATE_AJAX_TO_RESOURCE_HYPERLINK, resourceId, "httplifecycle", "responseAsYaml");
            sequencedResponseBuilder.append(this.interpolateHtmlTableRowTemplate("RAW YAML", ajaxLinkToResponseAsYaml));
            responseTableBuilder.append(String.format(TEMPLATE_HTML_TABLE, responseTableTitle, sequencedResponseBuilder.toString()));
        }
        return responseTableBuilder.toString();
    }

    private String buildJvmParametersHtmlTable() throws Exception {
        StringBuilder builder = new StringBuilder();
        if (!RUNTIME_MX_BEAN.getInputArguments().isEmpty()) {
            builder.append(this.interpolateHtmlTableRowTemplate("INPUT ARGS", RUNTIME_MX_BEAN.getInputArguments()));
        }
        builder.append(this.interpolateHtmlTableRowTemplate("HEAP MEMORY USAGE", MEMORY_MX_BEAN.getHeapMemoryUsage()));
        builder.append(this.interpolateHtmlTableRowTemplate("NON-HEAP MEMORY USAGE", MEMORY_MX_BEAN.getNonHeapMemoryUsage()));
        return String.format(TEMPLATE_HTML_TABLE, "jvm", builder.toString());
    }

    private String buildJettyParametersHtmlTable() throws Exception {
        StringBuilder builder = new StringBuilder();
        String host = this.jettyContext.getHost();
        int adminPort = this.jettyContext.getAdminPort();
        builder.append(this.interpolateHtmlTableRowTemplate("HOST", host));
        builder.append(this.interpolateHtmlTableRowTemplate("ADMIN PORT", adminPort));
        builder.append(this.interpolateHtmlTableRowTemplate("STUBS PORT", this.jettyContext.getStubsPort()));
        builder.append(this.interpolateHtmlTableRowTemplate("STUBS TLS PORT", this.jettyContext.getStubsTlsPort()));
        String endpointRegistration = HandlerUtils.linkifyRequestUrl(HttpScheme.HTTP.asString(), "/", host, adminPort);
        builder.append(this.interpolateHtmlTableRowTemplate("NEW STUB DATA POST URI", endpointRegistration));
        return String.format(TEMPLATE_HTML_TABLE, "jetty parameters", builder.toString());
    }

    private String buildStubbyParametersHtmlTable() throws Exception {
        StringBuilder builder = new StringBuilder();
        builder.append(this.interpolateHtmlTableRowTemplate("VERSION", JarUtils.readManifestImplementationVersion()));
        builder.append(this.interpolateHtmlTableRowTemplate("RUNTIME CLASSPATH", RUNTIME_MX_BEAN.getClassPath()));
        builder.append(this.interpolateHtmlTableRowTemplate("LOCAL BUILT DATE", JarUtils.readManifestBuiltDate()));
        builder.append(this.interpolateHtmlTableRowTemplate("UPTIME", HandlerUtils.calculateStubbyUpTime(RUNTIME_MX_BEAN.getUptime())));
        builder.append(this.interpolateHtmlTableRowTemplate("INPUT ARGS", CommandLineInterpreter.PROVIDED_OPTIONS));
        builder.append(this.interpolateHtmlTableRowTemplate("STUBBED ENDPOINTS", this.stubbedDataManager.getStubHttpLifecycles().size()));
        builder.append(this.interpolateHtmlTableRowTemplate("LOADED YAML", this.buildLoadedFileMetadata(this.stubbedDataManager.getDataYaml())));
        if (!this.stubbedDataManager.getExternalFiles().isEmpty()) {
            StringBuilder externalFilesMetadata = new StringBuilder();
            for (Map.Entry<File, Long> entry : this.stubbedDataManager.getExternalFiles().entrySet()) {
                File externalFile = entry.getKey();
                externalFilesMetadata.append(this.buildLoadedFileMetadata(externalFile));
            }
            builder.append(this.interpolateHtmlTableRowTemplate("LOADED EXTERNAL FILES", externalFilesMetadata.toString()));
        }
        return String.format(TEMPLATE_HTML_TABLE, "stubby4j parameters", builder.toString());
    }

    private String buildEndpointStatsHtmlTable() throws Exception {
        StringBuilder builder = new StringBuilder();
        if (this.stubbedDataManager.getResourceStats().isEmpty()) {
            builder.append(this.interpolateHtmlTableRowTemplate("ENDPOINT HITS", "No requests were made to stubby yet"));
        } else {
            builder.append(this.interpolateHtmlTableRowTemplate("ENDPOINT HITS", TEMPLATE_AJAX_TO_STATS_HYPERLINK));
        }
        return String.format(TEMPLATE_HTML_TABLE, "stubby stats", builder.toString());
    }

    private String buildLoadedFileMetadata(File file) throws IOException {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format(TEMPLATE_LOADED_FILE_METADATA_PAIR, "parentDir", this.determineParentDir(file))).append("<br />");
        builder.append(String.format(TEMPLATE_LOADED_FILE_METADATA_PAIR, "name", file.getName())).append("<br />");
        builder.append(String.format(TEMPLATE_LOADED_FILE_METADATA_PAIR, "size", String.format("%1$,.2f", (double)file.length() / 1024.0) + "kb")).append("<br />");
        builder.append(String.format(TEMPLATE_LOADED_FILE_METADATA_PAIR, "lastModified", new Date(file.lastModified()))).append("<br />");
        return "<div style='margin-top: 5px; padding: 3px 7px 3px 7px; background-color: #fefefe'>" + builder.toString() + "</div>";
    }

    private String determineParentDir(File file) throws IOException {
        return ObjectUtils.isNull(file.getParentFile()) ? file.getCanonicalPath().replaceAll(file.getName(), "") : file.getParentFile().getCanonicalPath() + "/";
    }

    private StringBuilder buildStubHtmlTableBody(String resourceId, String stubTypeName, Map<String, String> stubObjectProperties) throws Exception {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> keyValue : stubObjectProperties.entrySet()) {
            String value = keyValue.getValue();
            String key = keyValue.getKey();
            if (!StringUtils.isSet(value)) continue;
            builder.append(this.buildHtmlTableSingleRow(resourceId, stubTypeName, key, value));
        }
        return builder;
    }

    private String buildHtmlTableSingleRow(String resourceId, String stubTypeName, String fieldName, String value) {
        if (FIELDS_FOR_AJAX_LINKS.contains(fieldName)) {
            String cleansedStubTypeName = stubTypeName.replaceAll(NEXT_IN_THE_QUEUE, "");
            String ajaxHyperlink = String.format(TEMPLATE_AJAX_TO_RESOURCE_HYPERLINK, resourceId, cleansedStubTypeName, fieldName);
            return this.interpolateHtmlTableRowTemplate(StringUtils.toUpper(fieldName), ajaxHyperlink);
        }
        String escapedValue = StringUtils.escapeHtmlEntities(value);
        if (fieldName.equals("url")) {
            String urlAsHyperlink = HandlerUtils.linkifyRequestUrl(HttpScheme.HTTP.asString(), escapedValue, this.jettyContext.getHost(), this.jettyContext.getStubsPort());
            String tlsUrlAsHyperlink = HandlerUtils.linkifyRequestUrl(HttpScheme.HTTPS.asString(), escapedValue, this.jettyContext.getHost(), this.jettyContext.getStubsTlsPort());
            String tableRowWithUrl = this.interpolateHtmlTableRowTemplate(StringUtils.toUpper(fieldName), urlAsHyperlink);
            String tableRowWithTlsUrl = this.interpolateHtmlTableRowTemplate("TLS " + StringUtils.toUpper(fieldName), tlsUrlAsHyperlink);
            return String.format("%s%s", tableRowWithUrl, tableRowWithTlsUrl);
        }
        return this.interpolateHtmlTableRowTemplate(StringUtils.toUpper(fieldName), escapedValue);
    }

    private String interpolateHtmlTableRowTemplate(Object ... tokens) {
        return String.format(TEMPLATE_HTML_TABLE_ROW, tokens);
    }
}

