/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.handlers.strategy.admin;

import io.github.azagniotov.stubby4j.database.StubbedDataManager;
import io.github.azagniotov.stubby4j.handlers.strategy.admin.AdminResponseHandlingStrategy;
import io.github.azagniotov.stubby4j.utils.HandlerUtils;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DeleteHandlingStrategy
implements AdminResponseHandlingStrategy {
    @Override
    public void handle(HttpServletRequest request, HttpServletResponse response, StubbedDataManager stubbedDataManager) throws IOException {
        if (request.getRequestURI().equals("/")) {
            response.setStatus(405);
            response.getWriter().println("Method DELETE is not allowed on URI " + request.getRequestURI());
            return;
        }
        int contextPathLength = "/".length();
        String pathInfoNoHeadingSlash = request.getRequestURI().substring(contextPathLength);
        int stubIndexToDelete = Integer.parseInt(pathInfoNoHeadingSlash);
        if (!stubbedDataManager.isStubHttpLifecycleExistsByIndex(stubIndexToDelete)) {
            String errorMessage = String.format("Stub request index#%s does not exist, cannot delete", stubIndexToDelete);
            HandlerUtils.configureErrorResponse(response, 204, errorMessage);
            return;
        }
        stubbedDataManager.deleteStubHttpLifecycleByIndex(stubIndexToDelete);
        response.setStatus(200);
        response.getWriter().println(String.format("Stub request index#%s deleted successfully", stubIndexToDelete));
    }
}

