/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.handlers.strategy.stubs;

import io.github.azagniotov.stubby4j.handlers.strategy.stubs.StubResponseHandlingStrategy;
import io.github.azagniotov.stubby4j.utils.FileUtils;
import io.github.azagniotov.stubby4j.utils.HandlerUtils;
import io.github.azagniotov.stubby4j.utils.StringUtils;
import io.github.azagniotov.stubby4j.yaml.stubs.StubRequest;
import io.github.azagniotov.stubby4j.yaml.stubs.StubResponse;
import java.io.File;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;

public final class DefaultResponseHandlingStrategy
implements StubResponseHandlingStrategy {
    private final StubResponse foundStubResponse;

    public DefaultResponseHandlingStrategy(StubResponse foundStubResponse) {
        this.foundStubResponse = foundStubResponse;
    }

    @Override
    public void handle(HttpServletResponse response, StubRequest assertionStubRequest) throws Exception {
        HandlerUtils.setResponseMainHeaders(response);
        this.setStubResponseHeaders(this.foundStubResponse, response);
        if (StringUtils.isSet(this.foundStubResponse.getLatency())) {
            long latency = Long.parseLong(this.foundStubResponse.getLatency());
            TimeUnit.MILLISECONDS.sleep(latency);
        }
        response.setStatus(Integer.parseInt(this.foundStubResponse.getStatus()));
        byte[] responseBody = this.foundStubResponse.getResponseBodyAsBytes();
        if (this.foundStubResponse.doesFilePathContainTemplateTokens()) {
            String resolvedPath = StringUtils.replaceTokensInString(this.foundStubResponse.getRawFile().getAbsolutePath(), assertionStubRequest.getRegexGroups());
            File resolvedFile = new File(resolvedPath);
            if (resolvedFile.exists()) {
                responseBody = FileUtils.fileToBytes(resolvedFile);
            } else {
                response.setStatus(404);
            }
        } else if (this.foundStubResponse.isContainsTemplateTokens()) {
            String replacedTemplate = StringUtils.replaceTokens(responseBody, assertionStubRequest.getRegexGroups());
            responseBody = StringUtils.getBytesUtf8(replacedTemplate);
        }
        ServletOutputStream streamOut = response.getOutputStream();
        streamOut.write(responseBody);
        streamOut.flush();
        streamOut.close();
    }

    private void setStubResponseHeaders(StubResponse stubResponse, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        for (Map.Entry<String, String> entry : stubResponse.getHeaders().entrySet()) {
            response.setHeader(entry.getKey(), entry.getValue());
        }
    }
}

