/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.handlers.strategy.stubs;

import io.github.azagniotov.stubby4j.handlers.strategy.stubs.DefaultResponseHandlingStrategy;
import io.github.azagniotov.stubby4j.handlers.strategy.stubs.NotFoundResponseHandlingStrategy;
import io.github.azagniotov.stubby4j.handlers.strategy.stubs.RedirectResponseHandlingStrategy;
import io.github.azagniotov.stubby4j.handlers.strategy.stubs.StubResponseHandlingStrategy;
import io.github.azagniotov.stubby4j.handlers.strategy.stubs.UnauthorizedResponseHandlingStrategy;
import io.github.azagniotov.stubby4j.yaml.stubs.StubResponse;

public final class StubsResponseHandlingStrategyFactory {
    private StubsResponseHandlingStrategyFactory() {
    }

    public static StubResponseHandlingStrategy getStrategy(StubResponse foundStubResponse) {
        switch (foundStubResponse.getStubResponseType()) {
            case NOTFOUND: {
                return new NotFoundResponseHandlingStrategy();
            }
            case UNAUTHORIZED: {
                return new UnauthorizedResponseHandlingStrategy();
            }
            case REDIRECT: {
                return new RedirectResponseHandlingStrategy(foundStubResponse);
            }
        }
        return new DefaultResponseHandlingStrategy(foundStubResponse);
    }
}

