/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.server;

import io.github.azagniotov.stubby4j.cli.ANSITerminal;
import io.github.azagniotov.stubby4j.cli.EmptyLogger;
import io.github.azagniotov.stubby4j.database.StubbedDataManager;
import io.github.azagniotov.stubby4j.database.thread.ExternalFilesScanner;
import io.github.azagniotov.stubby4j.database.thread.MainYamlScanner;
import io.github.azagniotov.stubby4j.server.JettyFactory;
import io.github.azagniotov.stubby4j.server.StubbyManager;
import io.github.azagniotov.stubby4j.utils.FileUtils;
import io.github.azagniotov.stubby4j.utils.ObjectUtils;
import io.github.azagniotov.stubby4j.yaml.YamlParser;
import io.github.azagniotov.stubby4j.yaml.stubs.StubHttpLifecycle;
import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;

public class StubbyManagerFactory {
    public synchronized StubbyManager construct(String dataYamlFilename, Map<String, String> commandLineArgs) throws Exception {
        Log.setLog(new EmptyLogger());
        File dataYamlFile = new File(dataYamlFilename);
        List<StubHttpLifecycle> httpLifecycles = new YamlParser().parse(dataYamlFile.getParent(), FileUtils.constructReader(dataYamlFile));
        System.out.println();
        StubbedDataManager stubbedDataManager = new StubbedDataManager(dataYamlFile, httpLifecycles);
        JettyFactory jettyFactory = new JettyFactory(commandLineArgs, stubbedDataManager);
        Server server = jettyFactory.construct();
        if (commandLineArgs.containsKey("watch")) {
            String watchValue = commandLineArgs.get("watch");
            long watchScanTime = ObjectUtils.isNotNull(watchValue) ? Long.parseLong(watchValue) : 100L;
            this.watchDataStore(stubbedDataManager, watchScanTime);
        }
        if (commandLineArgs.containsKey("mute")) {
            ANSITerminal.muteConsole(true);
        }
        return new StubbyManager(server);
    }

    private void watchDataStore(StubbedDataManager stubbedDataManager, long sleepTime) {
        MainYamlScanner mainYamlScanner = new MainYamlScanner(stubbedDataManager, sleepTime);
        new Thread((Runnable)mainYamlScanner, MainYamlScanner.class.getCanonicalName()).start();
        ExternalFilesScanner externalFilesScanner = new ExternalFilesScanner(stubbedDataManager, sleepTime);
        new Thread((Runnable)externalFilesScanner, ExternalFilesScanner.class.getCanonicalName()).start();
    }
}

