/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.utils;

import io.github.azagniotov.stubby4j.cli.ANSITerminal;
import io.github.azagniotov.stubby4j.utils.FileUtils;
import io.github.azagniotov.stubby4j.utils.HttpRequestUtils;
import io.github.azagniotov.stubby4j.yaml.stubs.StubRequest;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpStatus;

public final class ConsoleUtils {
    private static boolean debug = false;

    private ConsoleUtils() {
    }

    public static void logIncomingRequestError(HttpServletRequest request, String source, String error) {
        String logMessage = String.format("[%s] -> %s [%s]%s: %s", ConsoleUtils.getTime(), request.getMethod(), source, request.getRequestURI(), error);
        ANSITerminal.error(logMessage);
    }

    public static void logRawIncomingRequest(HttpServletRequest request) {
        ANSITerminal.warn(" ***** [DEBUG INCOMING RAW HTTP REQUEST DUMP] ***** ");
        ANSITerminal.info(HttpRequestUtils.dump(request));
        ANSITerminal.warn(" ***** [DEBUG INCOMING RAW HTTP REQUEST DUMP] ***** " + FileUtils.BR);
    }

    public static void logIncomingRequest(HttpServletRequest request) {
        String logMessage = String.format("[%s] -> %s [%s]", ConsoleUtils.getTime(), request.getMethod(), request.getRequestURI());
        ANSITerminal.incoming(logMessage);
        if (debug) {
            ConsoleUtils.logRawIncomingRequest(request);
        }
    }

    public static void logAssertingRequest(StubRequest assertingStubRequest) {
        if (debug) {
            ANSITerminal.warn(" ***** [DEBUG INCOMING ASSERTING HTTP REQUEST DUMP] ***** ");
            ANSITerminal.info(assertingStubRequest.toString());
            ANSITerminal.warn(" ***** [DEBUG INCOMING ASSERTING HTTP REQUEST DUMP] ***** " + FileUtils.BR);
        }
    }

    public static void logOutgoingResponse(String url, HttpServletResponse response) {
        int status = response.getStatus();
        String logMessage = String.format("[%s] <- %s [%s] %s", ConsoleUtils.getTime(), status, url, HttpStatus.getMessage(status));
        if (status >= 400) {
            ANSITerminal.error(logMessage);
        } else if (status >= 300) {
            ANSITerminal.warn(logMessage);
        } else if (status >= 200) {
            ANSITerminal.ok(logMessage);
        } else if (status >= 100) {
            ANSITerminal.info(logMessage);
        } else {
            ANSITerminal.log(logMessage);
        }
    }

    public static void logUnmarshalledStubRequest(List<String> methods, String url) {
        String loadedMsg = String.format("Loaded: %s %s", methods, url);
        ANSITerminal.loaded(loadedMsg);
    }

    public static String getTime() {
        Calendar now = Calendar.getInstance(Locale.US);
        return String.format("%02d:%02d:%02d", now.get(11), now.get(12), now.get(13));
    }

    public static void enableDebug(boolean isDebug) {
        debug = isDebug;
    }
}

