/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.utils;

import io.github.azagniotov.stubby4j.annotations.CoberturaIgnore;
import io.github.azagniotov.stubby4j.common.Common;
import io.github.azagniotov.stubby4j.exception.Stubby4JException;
import io.github.azagniotov.stubby4j.utils.ConsoleUtils;
import io.github.azagniotov.stubby4j.utils.ObjectUtils;
import io.github.azagniotov.stubby4j.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;

public final class HandlerUtils {
    private HandlerUtils() {
    }

    public static void configureErrorResponse(HttpServletResponse response, int httpStatus, String message) throws IOException {
        response.setStatus(httpStatus);
        response.sendError(httpStatus, message);
        response.flushBuffer();
    }

    public static String getHtmlResourceByName(String templateSuffix) {
        String htmlTemplatePath = String.format("/ui/html/%s.html", templateSuffix);
        InputStream inputStream = HandlerUtils.class.getResourceAsStream(htmlTemplatePath);
        if (ObjectUtils.isNull(inputStream)) {
            throw new Stubby4JException(String.format("Could not find resource %s", htmlTemplatePath));
        }
        return StringUtils.inputStreamToString(inputStream);
    }

    @CoberturaIgnore
    public static String constructHeaderServerName() {
        Package pkg = HandlerUtils.class.getPackage();
        String implementationVersion = StringUtils.isSet(pkg.getImplementationVersion()) ? pkg.getImplementationVersion() : "x.x.xx";
        return String.format("stubby4j/%s (HTTP stub server)", implementationVersion);
    }

    public static void setResponseMainHeaders(HttpServletResponse response) {
        response.setHeader(HttpHeader.SERVER.asString(), HandlerUtils.constructHeaderServerName());
        response.setHeader(HttpHeader.DATE.asString(), new Date().toString());
        response.setHeader(HttpHeader.CONTENT_TYPE.asString(), "text/html;charset=UTF-8");
        response.setHeader(HttpHeader.CACHE_CONTROL.asString(), "no-cache, no-store, must-revalidate");
        response.setHeader(HttpHeader.PRAGMA.asString(), "no-cache");
        response.setDateHeader(HttpHeader.EXPIRES.asString(), 0L);
    }

    public static String linkifyRequestUrl(String scheme, Object uri, String host, int port) {
        String fullUrl = String.format("%s://%s:%s%s", scheme.toLowerCase(), host, port, uri);
        String href = StringUtils.encodeSingleQuotes(fullUrl);
        return String.format("<a target='_blank' href='%s'>%s</a>", href, fullUrl);
    }

    public static String populateHtmlTemplate(String templateName, Object ... params) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format(HandlerUtils.getHtmlResourceByName(templateName), params));
        return builder.toString();
    }

    public static String extractPostRequestBody(HttpServletRequest request, String source) throws IOException {
        if (!Common.POSTING_METHODS.contains(request.getMethod().toUpperCase())) {
            return null;
        }
        try {
            String requestContent = StringUtils.inputStreamToString(request.getInputStream());
            return requestContent.replaceAll("\\\\/", "/");
        }
        catch (Exception ex) {
            String err = String.format("Error when extracting POST body: %s, returning null..", ex.toString());
            ConsoleUtils.logIncomingRequestError(request, source, err);
            return null;
        }
    }

    public static String calculateStubbyUpTime(long timestamp) {
        long days = TimeUnit.MILLISECONDS.toDays(timestamp);
        long hours = TimeUnit.MILLISECONDS.toHours(timestamp) - TimeUnit.DAYS.toHours(TimeUnit.MILLISECONDS.toDays(timestamp));
        long mins = TimeUnit.MILLISECONDS.toMinutes(timestamp) - TimeUnit.HOURS.toMinutes(TimeUnit.MILLISECONDS.toHours(timestamp));
        long secs = TimeUnit.MILLISECONDS.toSeconds(timestamp) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(timestamp));
        return String.format("%d day%s, %d hour%s, %d min%s, %d sec%s", days, HandlerUtils.pluralize(days), hours, HandlerUtils.pluralize(hours), mins, HandlerUtils.pluralize(mins), secs, HandlerUtils.pluralize(secs));
    }

    private static String pluralize(long timeUnit) {
        return timeUnit == 1L ? "" : "s";
    }
}

