/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.utils;

import io.github.azagniotov.stubby4j.utils.FileUtils;
import io.github.azagniotov.stubby4j.utils.StringUtils;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public final class HttpRequestUtils {
    private static final String INDENT_UNIT = "   ";
    private static final String LEFT_BRACKET = "[";
    private static final String RIGHT_BRACKET = "]";
    private static final String LEFT_CURLY_BRACE = "{";
    private static final String RIGHT_CURLY_BRACE = "}";
    private static final String COMMA = ",";
    private static final String EMPTY_BRACES = "{}";

    private HttpRequestUtils() {
    }

    private static String debugStringParameter(String indentString, String parameterName, String[] parameterValues) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(indentString).append(INDENT_UNIT).append("'").append(parameterName).append("': ");
        if (parameterValues == null || parameterValues.length == 0) {
            stringBuilder.append("None");
        } else {
            String joined;
            if (parameterValues.length > 1) {
                stringBuilder.append(LEFT_BRACKET);
            }
            stringBuilder.append((joined = StringUtils.join(parameterValues, COMMA.charAt(0))).trim().equals("") ? "''" : joined);
            if (parameterValues.length > 1) {
                stringBuilder.append(RIGHT_BRACKET);
            }
        }
        return stringBuilder.toString();
    }

    private static String debugStringHeader(String indentString, String headerName, List<String> headerValues) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(indentString).append(INDENT_UNIT).append("'").append(headerName).append("': ");
        if (headerValues == null || headerValues.size() == 0) {
            stringBuilder.append("None");
        } else {
            if (headerValues.size() > 1) {
                stringBuilder.append(LEFT_BRACKET);
            }
            stringBuilder.append(StringUtils.join(headerValues.toArray(new String[headerValues.size()]), COMMA.charAt(0)));
            if (headerValues.size() > 1) {
                stringBuilder.append(RIGHT_BRACKET);
            }
        }
        return stringBuilder.toString();
    }

    private static String debugStringHeaders(HttpServletRequest request, int indent) {
        Enumeration<String> headerNames = request.getHeaderNames();
        if (headerNames == null || !headerNames.hasMoreElements()) {
            return EMPTY_BRACES;
        }
        String indentString = StringUtils.repeat(INDENT_UNIT, indent);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(LEFT_CURLY_BRACE).append(FileUtils.BR);
        while (headerNames.hasMoreElements()) {
            String headerName = headerNames.nextElement();
            Enumeration<String> headerValues = request.getHeaders(headerName);
            ArrayList<String> headerValuesList = new ArrayList<String>();
            while (headerValues != null && headerValues.hasMoreElements()) {
                headerValuesList.add(headerValues.nextElement());
            }
            stringBuilder.append(HttpRequestUtils.debugStringHeader(indentString, headerName, headerValuesList)).append(COMMA).append(FileUtils.BR);
        }
        stringBuilder.append(indentString).append(RIGHT_CURLY_BRACE);
        return stringBuilder.toString();
    }

    public static String dump(HttpServletRequest request) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("   PROTOCOL: ").append(request.getProtocol()).append(FileUtils.BR);
        stringBuilder.append("   METHOD: ").append(request.getMethod()).append(FileUtils.BR);
        stringBuilder.append("   CONTEXT PATH: ").append(request.getContextPath()).append(FileUtils.BR);
        stringBuilder.append("   SERVLET PATH: ").append(request.getServletPath()).append(FileUtils.BR);
        stringBuilder.append("   AUTH TYPE: ").append(request.getAuthType()).append(FileUtils.BR);
        stringBuilder.append("   REMOTE USER: ").append(request.getRemoteUser()).append(FileUtils.BR);
        stringBuilder.append("   REQUEST URI: ").append(request.getRequestURI()).append(FileUtils.BR);
        stringBuilder.append("   REQUEST URL: ").append(request.getRequestURL()).append(FileUtils.BR);
        stringBuilder.append("   QUERY STRING: ").append(request.getQueryString()).append(FileUtils.BR);
        stringBuilder.append("   PATH INFO: ").append(request.getPathInfo()).append(FileUtils.BR);
        stringBuilder.append("   PATH TRANSLATED: ").append(request.getPathTranslated()).append(FileUtils.BR);
        stringBuilder.append("   HEADERS: ").append(HttpRequestUtils.debugStringHeaders(request, 1));
        return stringBuilder.toString();
    }
}

