/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.utils;

import io.github.azagniotov.stubby4j.utils.StringUtils;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ReflectionUtils {
    private static List<String> skipableProperties = Collections.unmodifiableList(Arrays.asList("STUBBY_RESOURCE_ID_HEADER", "regexGroups", "fileBytes"));

    private ReflectionUtils() {
    }

    public static Map<String, String> getProperties(Object object) throws IllegalAccessException, InvocationTargetException, UnsupportedEncodingException {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (final Field field : object.getClass().getDeclaredFields()) {
            Object fieldObject;
            String value;
            AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    return true;
                }
            });
            if (skipableProperties.contains(field.getName()) || (value = StringUtils.objectToString(fieldObject = ReflectionUtils.getPropertyValue(object, field.getName()))).equals("Not provided") || value.equals("{}")) continue;
            properties.put(StringUtils.toLower(field.getName()), value);
        }
        return properties;
    }

    public static void injectObjectFields(Object target, String fieldName, Object value) throws InvocationTargetException, IllegalAccessException {
        HashMap<String, Object> fieldAndValue = new HashMap<String, Object>();
        fieldAndValue.put(fieldName.toLowerCase(), value);
        ReflectionUtils.injectObjectFields(target, fieldAndValue);
    }

    public static void injectObjectFields(Object object, Map<String, Object> fieldsAndValues) throws InvocationTargetException, IllegalAccessException {
        for (final Field field : object.getClass().getDeclaredFields()) {
            String fieldName = field.getName().toLowerCase();
            if (!fieldsAndValues.containsKey(fieldName)) continue;
            AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    return true;
                }
            });
            field.set(object, fieldsAndValues.get(fieldName));
        }
    }

    public static Object getPropertyValue(Object object, String fieldName) throws InvocationTargetException, IllegalAccessException {
        for (Method method : object.getClass().getDeclaredMethods()) {
            if (!method.getName().equalsIgnoreCase("get" + fieldName)) continue;
            return method.invoke(object, new Object[0]);
        }
        return null;
    }
}

