/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.utils;

import io.github.azagniotov.stubby4j.annotations.CoberturaIgnore;
import io.github.azagniotov.stubby4j.repackaged.org.apache.commons.codec.binary.Base64;
import io.github.azagniotov.stubby4j.utils.ObjectUtils;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;

public final class StringUtils {
    public static final String NOT_PROVIDED = "Not provided";
    public static final int PAD_LIMIT = 8192;
    public static final String TEMPLATE_TOKEN_LEFT = "<%";
    public static final String TEMPLATE_TOKEN_RIGHT = "%>";
    public static final String UTF_8 = "UTF-8";
    public static final String FAILED = "Failed to load response content using relative path specified in 'file' during YAML parse time. Check terminal for warnings, and that response content exists in relative path specified in 'file'";
    private static final CharsetEncoder US_ASCII_ENCODER = Charset.forName("US-ASCII").newEncoder();

    private StringUtils() {
    }

    public static boolean isUSAscii(String toTest) {
        return US_ASCII_ENCODER.canEncode(toTest);
    }

    public static boolean isSet(String toTest) {
        return ObjectUtils.isNotNull(toTest) && toTest.trim().length() > 0;
    }

    public static String toUpper(String toUpper) {
        if (!StringUtils.isSet(toUpper)) {
            return "";
        }
        return toUpper.toUpperCase(Locale.US);
    }

    public static String toLower(String toLower) {
        if (!StringUtils.isSet(toLower)) {
            return "";
        }
        return toLower.toLowerCase(Locale.US);
    }

    public static Charset charsetUTF8() {
        return Charset.forName(UTF_8);
    }

    public static String newStringUtf8(byte[] bytes) {
        return new String(bytes, StringUtils.charsetUTF8());
    }

    public static byte[] getBytesUtf8(String string) {
        return string.getBytes(StringUtils.charsetUTF8());
    }

    public static String inputStreamToString(InputStream inputStream) {
        if (ObjectUtils.isNull(inputStream)) {
            return "Could not convert empty or null input stream to string";
        }
        return new Scanner(inputStream, UTF_8).useDelimiter("\\A").next().trim();
    }

    public static String buildToken(String propertyName, int capturingGroupIdx) {
        return String.format("%s.%s", propertyName, capturingGroupIdx);
    }

    public static String replaceTokens(byte[] stringBytes, Map<String, String> tokensAndValues) {
        return StringUtils.replaceTokensInString(StringUtils.newStringUtf8(stringBytes), tokensAndValues);
    }

    public static String replaceTokensInString(String template, Map<String, String> tokensAndValues) {
        for (Map.Entry<String, String> entry : tokensAndValues.entrySet()) {
            String regexifiedKey = String.format("%s\\s{0,}%s\\s{0,}%s", TEMPLATE_TOKEN_LEFT, entry.getKey(), TEMPLATE_TOKEN_RIGHT);
            template = template.replaceAll(regexifiedKey, entry.getValue());
        }
        return template;
    }

    public static String escapeHtmlEntities(String toBeEscaped) {
        return toBeEscaped.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static String trimSpacesBetweenCSVElements(String toBeFiltered) {
        return toBeFiltered.replaceAll("\",\\s+\"", "\",\"").replaceAll(",\\s+", ",");
    }

    public static String removeSquareBrackets(String toBeFiltered) {
        return toBeFiltered.replaceAll("%5B|%5D|\\[|]", "");
    }

    public static boolean isWithinSquareBrackets(String toCheck) {
        if (toCheck.startsWith("%5B") && toCheck.endsWith("%5D")) {
            return true;
        }
        return toCheck.startsWith("[") && toCheck.endsWith("]");
    }

    public static String decodeUrlEncoded(String toCheck) {
        if (toCheck.contains("%2B")) {
            return toCheck.replaceAll("%2B", " ").replaceAll("\\s+", " ");
        }
        if (toCheck.contains("%20")) {
            return toCheck.replaceAll("%20", " ").replaceAll("\\s+", " ");
        }
        if (toCheck.contains("+")) {
            return toCheck.replaceAll(Pattern.quote("+"), " ").replaceAll("\\s+", " ");
        }
        return toCheck;
    }

    public static String escapeCurlyBraces(String toEscape) {
        return toEscape.replaceAll(Pattern.quote("{"), "\\\\{").replaceAll(Pattern.quote("}"), "\\\\}");
    }

    public static String decodeUrlEncodedQuotes(String toBeFiltered) {
        return toBeFiltered.replaceAll("%22", "\"").replaceAll("%27", "'");
    }

    public static String encodeSingleQuotes(String toBeEncoded) {
        return toBeEncoded.replaceAll("'", "%27");
    }

    public static String extractFilenameExtension(String filename) {
        int dotLocation = filename.lastIndexOf(46);
        return filename.substring(dotLocation);
    }

    @CoberturaIgnore
    public static String constructUserAgentName() {
        Package pkg = StringUtils.class.getPackage();
        String implementationVersion = StringUtils.isSet(pkg.getImplementationVersion()) ? pkg.getImplementationVersion() : "x.x.xx";
        return String.format("stubby4j/%s (HTTP stub client request)", implementationVersion);
    }

    public static String encodeBase64(String toEncode) {
        return Base64.encodeBase64String(StringUtils.getBytesUtf8(toEncode));
    }

    public static int calculateStringLength(String post) {
        if (StringUtils.isSet(post)) {
            return post.getBytes(StringUtils.charsetUTF8()).length;
        }
        return 0;
    }

    public static String objectToString(Object fieldObject) {
        if (ObjectUtils.isNull(fieldObject)) {
            return NOT_PROVIDED;
        }
        if (fieldObject instanceof byte[]) {
            byte[] objectBytes = (byte[])fieldObject;
            String toTest = StringUtils.newStringUtf8(objectBytes);
            if (!StringUtils.isUSAscii(toTest)) {
                return "Loaded file is binary - it's content is not displayable";
            }
            if (toTest.equals(FAILED)) {
                return FAILED;
            }
            try {
                return new String(objectBytes, UTF_8);
            }
            catch (UnsupportedEncodingException e) {
                return new String(objectBytes);
            }
        }
        String valueAsStr = ObjectUtils.isNotNull(fieldObject) ? fieldObject.toString().trim() : "";
        return !valueAsStr.equalsIgnoreCase("null") ? valueAsStr : "";
    }

    public static String join(String[] array, char separator) {
        if (array == null) {
            return null;
        }
        boolean startIndex = false;
        int endIndex = array.length;
        int noOfItems = endIndex - 0;
        if (noOfItems <= 0) {
            return "";
        }
        StringBuilder buf = new StringBuilder(noOfItems * 16);
        for (int i = 0; i < endIndex; ++i) {
            if (i > 0) {
                buf.append(separator);
            }
            if (array[i] == null) continue;
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static String repeat(String str, int repeat) {
        if (str == null) {
            return null;
        }
        if (repeat <= 0) {
            return "";
        }
        int inputLength = str.length();
        if (repeat == 1 || inputLength == 0) {
            return str;
        }
        if (inputLength == 1 && repeat <= 8192) {
            return StringUtils.repeat(str.charAt(0), repeat);
        }
        int outputLength = inputLength * repeat;
        switch (inputLength) {
            case 1: {
                return StringUtils.repeat(str.charAt(0), repeat);
            }
            case 2: {
                char ch0 = str.charAt(0);
                char ch1 = str.charAt(1);
                char[] output2 = new char[outputLength];
                for (int i = repeat * 2 - 2; i >= 0; --i) {
                    output2[i] = ch0;
                    output2[i + 1] = ch1;
                    --i;
                }
                return new String(output2);
            }
        }
        StringBuilder buf = new StringBuilder(outputLength);
        for (int i = 0; i < repeat; ++i) {
            buf.append(str);
        }
        return buf.toString();
    }

    private static String repeat(char ch, int repeat) {
        char[] buf = new char[repeat];
        for (int i = repeat - 1; i >= 0; --i) {
            buf[i] = ch;
        }
        return new String(buf);
    }
}

