/*
 * Decompiled with CFR 0.152.
 */
package io.github.azagniotov.stubby4j.yaml.stubs;

import io.github.azagniotov.stubby4j.annotations.CoberturaIgnore;
import io.github.azagniotov.stubby4j.annotations.VisibleForTesting;
import io.github.azagniotov.stubby4j.utils.CollectionUtils;
import io.github.azagniotov.stubby4j.utils.ConsoleUtils;
import io.github.azagniotov.stubby4j.utils.FileUtils;
import io.github.azagniotov.stubby4j.utils.HandlerUtils;
import io.github.azagniotov.stubby4j.utils.ObjectUtils;
import io.github.azagniotov.stubby4j.utils.StringUtils;
import io.github.azagniotov.stubby4j.yaml.stubs.StubAuthorizationTypes;
import java.io.File;
import java.io.IOException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.custommonkey.xmlunit.Diff;
import org.custommonkey.xmlunit.ElementNameAndAttributeQualifier;
import org.json.JSONException;
import org.skyscreamer.jsonassert.JSONCompare;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.xml.sax.SAXException;

public class StubRequest {
    public static final String HTTP_HEADER_AUTHORIZATION = "authorization";
    private final String url;
    private final String post;
    private final File file;
    private final byte[] fileBytes;
    private final List<String> method;
    private final Map<String, String> headers;
    private final Map<String, String> query;
    private final Map<String, String> regexGroups;

    public StubRequest(String url, String post, File file, List<String> method, Map<String, String> headers, Map<String, String> query) {
        this.url = url;
        this.post = post;
        this.file = file;
        this.fileBytes = ObjectUtils.isNull(file) ? new byte[]{} : this.getFileBytes();
        this.method = ObjectUtils.isNull(method) ? new ArrayList() : method;
        this.headers = ObjectUtils.isNull(headers) ? new LinkedHashMap() : headers;
        this.query = ObjectUtils.isNull(query) ? new LinkedHashMap() : query;
        this.regexGroups = new TreeMap<String, String>();
    }

    public final ArrayList<String> getMethod() {
        ArrayList<String> uppercase = new ArrayList<String>(this.method.size());
        for (String string : this.method) {
            uppercase.add(StringUtils.toUpper(string));
        }
        return uppercase;
    }

    public void addMethod(String newMethod) {
        if (StringUtils.isSet(newMethod)) {
            this.method.add(newMethod);
        }
    }

    public String getUrl() {
        if (this.getQuery().isEmpty()) {
            return this.url;
        }
        String queryString = CollectionUtils.constructQueryString(this.query);
        return String.format("%s?%s", this.url, queryString);
    }

    private byte[] getFileBytes() {
        try {
            return FileUtils.fileToBytes(this.file);
        }
        catch (Exception e) {
            return new byte[0];
        }
    }

    public String getPostBody() {
        if (this.fileBytes.length == 0) {
            return FileUtils.enforceSystemLineSeparator(this.post);
        }
        String utf8FileContent = StringUtils.newStringUtf8(this.fileBytes);
        return FileUtils.enforceSystemLineSeparator(utf8FileContent);
    }

    public String getPost() {
        return this.post;
    }

    public final Map<String, String> getHeaders() {
        LinkedHashMap<String, String> headersCopy = new LinkedHashMap<String, String>(this.headers);
        Set entrySet = headersCopy.entrySet();
        this.headers.clear();
        for (Map.Entry entry : entrySet) {
            this.headers.put(StringUtils.toLower((String)entry.getKey()), (String)entry.getValue());
        }
        return this.headers;
    }

    public Map<String, String> getQuery() {
        return this.query;
    }

    public byte[] getFile() {
        return this.fileBytes;
    }

    public Map<String, String> getRegexGroups() {
        return new TreeMap<String, String>(this.regexGroups);
    }

    public File getRawFile() {
        return this.file;
    }

    public boolean hasHeaders() {
        return !this.getHeaders().isEmpty();
    }

    public boolean hasQuery() {
        return !this.getQuery().isEmpty();
    }

    public boolean hasPostBody() {
        return StringUtils.isSet(this.getPostBody());
    }

    public boolean isSecured() {
        return this.getHeaders().containsKey(StubAuthorizationTypes.BASIC.asYamlProp()) || this.getHeaders().containsKey(StubAuthorizationTypes.BEARER.asYamlProp()) || this.getHeaders().containsKey(StubAuthorizationTypes.CUSTOM.asYamlProp());
    }

    @VisibleForTesting
    StubAuthorizationTypes getStubbedAuthorizationTypeHeader() {
        if (this.getHeaders().containsKey(StubAuthorizationTypes.BASIC.asYamlProp())) {
            return StubAuthorizationTypes.BASIC;
        }
        if (this.getHeaders().containsKey(StubAuthorizationTypes.BEARER.asYamlProp())) {
            return StubAuthorizationTypes.BEARER;
        }
        return StubAuthorizationTypes.CUSTOM;
    }

    String getStubbedAuthorizationHeaderValue(StubAuthorizationTypes stubbedAuthorizationHeaderType) {
        return this.getHeaders().get(stubbedAuthorizationHeaderType.asYamlProp());
    }

    public String getRawAuthorizationHttpHeader() {
        return this.getHeaders().get(HTTP_HEADER_AUTHORIZATION);
    }

    public static StubRequest newStubRequest() {
        return new StubRequest(null, null, null, null, null, null);
    }

    public static StubRequest newStubRequest(String url, String post) {
        return new StubRequest(url, post, null, null, null, null);
    }

    public static StubRequest createFromHttpServletRequest(HttpServletRequest request) throws IOException {
        StubRequest assertionRequest = StubRequest.newStubRequest(request.getPathInfo(), HandlerUtils.extractPostRequestBody(request, "stubs"));
        assertionRequest.addMethod(request.getMethod());
        Enumeration<String> headerNamesEnumeration = request.getHeaderNames();
        AbstractList headerNames = ObjectUtils.isNotNull(headerNamesEnumeration) ? Collections.list(request.getHeaderNames()) : new LinkedList();
        for (String headerName : headerNames) {
            String headerValue = request.getHeader(headerName);
            assertionRequest.getHeaders().put(StringUtils.toLower(headerName), headerValue);
        }
        assertionRequest.getQuery().putAll(CollectionUtils.constructParamMap(request.getQueryString()));
        ConsoleUtils.logAssertingRequest(assertionRequest);
        return assertionRequest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof StubRequest) {
            StubRequest stubbedRequest = (StubRequest)o;
            return this.urlsMatch(stubbedRequest.url, this.url) && this.arraysIntersect(stubbedRequest.getMethod(), this.getMethod()) && this.postBodiesMatch(stubbedRequest.isPostStubbed(), stubbedRequest.getPostBody(), this.getPostBody()) && this.headersMatch(stubbedRequest.getHeaders(), this.getHeaders()) && this.queriesMatch(stubbedRequest.getQuery(), this.getQuery());
        }
        return false;
    }

    @VisibleForTesting
    boolean isPostStubbed() {
        return StringUtils.isSet(this.getPostBody()) && (this.getMethod().contains("POST") || this.getMethod().contains("PUT"));
    }

    private boolean urlsMatch(String stubbedUrl, String assertingUrl) {
        return this.stringsMatch(stubbedUrl, assertingUrl, "url");
    }

    private boolean postBodiesMatch(boolean isPostStubbed, String stubbedPostBody, String assertingPostBody) {
        if (isPostStubbed) {
            String assertingContentType = this.getHeaders().get("content-type");
            boolean isAssertingValueSet = StringUtils.isSet(assertingPostBody);
            if (!isAssertingValueSet) {
                return false;
            }
            if (StringUtils.isSet(assertingContentType) && assertingContentType.contains("application/json")) {
                try {
                    boolean passed = JSONCompare.compareJSON(stubbedPostBody, assertingPostBody, JSONCompareMode.NON_EXTENSIBLE).passed();
                    if (passed) {
                        return true;
                    }
                    String escapedStubbedPostBody = StringUtils.escapeCurlyBraces(stubbedPostBody);
                    return this.regexMatch(escapedStubbedPostBody, assertingPostBody, "post");
                }
                catch (JSONException e) {
                    String escapedStubbedPostBody = StringUtils.escapeCurlyBraces(stubbedPostBody);
                    return this.regexMatch(escapedStubbedPostBody, assertingPostBody, "post");
                }
            }
            if (StringUtils.isSet(assertingContentType) && assertingContentType.contains("application/xml")) {
                try {
                    Diff diff = new Diff(stubbedPostBody, assertingPostBody);
                    diff.overrideElementQualifier(new ElementNameAndAttributeQualifier());
                    return diff.similar() || diff.identical();
                }
                catch (IOException | SAXException e) {
                    return false;
                }
            }
            String escapedStubbedPostBody = StringUtils.escapeCurlyBraces(stubbedPostBody);
            boolean regexMatch = this.regexMatch(escapedStubbedPostBody, assertingPostBody, "post");
            return regexMatch || this.stringsMatch(stubbedPostBody, assertingPostBody, "post");
        }
        return true;
    }

    private boolean queriesMatch(Map<String, String> stubbedQuery, Map<String, String> assertingQuery) {
        return this.mapsMatch(stubbedQuery, assertingQuery, "query");
    }

    private boolean headersMatch(Map<String, String> stubbedHeaders, Map<String, String> assertingHeaders) {
        HashMap<String, String> stubbedHeadersCopy = new HashMap<String, String>(stubbedHeaders);
        for (StubAuthorizationTypes authorizationType : StubAuthorizationTypes.values()) {
            stubbedHeadersCopy.remove(authorizationType.asYamlProp());
        }
        return this.mapsMatch(stubbedHeadersCopy, assertingHeaders, "headers");
    }

    @VisibleForTesting
    boolean mapsMatch(Map<String, String> stubbedMappings, Map<String, String> assertingMappings, String mapName) {
        if (stubbedMappings.isEmpty()) {
            return true;
        }
        if (assertingMappings.isEmpty()) {
            return false;
        }
        HashMap<String, String> stubbedMappingsCopy = new HashMap<String, String>(stubbedMappings);
        HashMap<String, String> assertingMappingsCopy = new HashMap<String, String>(assertingMappings);
        for (Map.Entry stubbedMappingEntry : stubbedMappingsCopy.entrySet()) {
            boolean containsRequiredParam = assertingMappingsCopy.containsKey(stubbedMappingEntry.getKey());
            if (!containsRequiredParam) {
                return false;
            }
            String assertingValue = (String)assertingMappingsCopy.get(stubbedMappingEntry.getKey());
            String templateTokenName = String.format("%s.%s", mapName, stubbedMappingEntry.getKey());
            String stubbedValue = (String)stubbedMappingEntry.getValue();
            if (this.stringsMatch(stubbedValue, assertingValue, templateTokenName)) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    boolean stringsMatch(String stubbedValue, String assertingValue, String templateTokenName) {
        boolean stubbedValueSet = StringUtils.isSet(stubbedValue);
        boolean assertingValueSet = StringUtils.isSet(assertingValue);
        if (!stubbedValueSet) {
            return true;
        }
        if (!assertingValueSet) {
            return false;
        }
        if (StringUtils.isWithinSquareBrackets(stubbedValue)) {
            return stubbedValue.equals(assertingValue);
        }
        return this.regexMatch(stubbedValue, assertingValue, templateTokenName);
    }

    private boolean regexMatch(String stubbedValue, String assertingValue, String templateTokenName) {
        try {
            Matcher matcher = Pattern.compile(stubbedValue, 8).matcher(assertingValue);
            boolean isMatch = matcher.matches();
            if (isMatch) {
                this.regexGroups.put(StringUtils.buildToken(templateTokenName, 0), matcher.group(0));
                int groupCount = matcher.groupCount();
                if (groupCount > 0) {
                    for (int idx = 1; idx <= groupCount; ++idx) {
                        this.regexGroups.put(StringUtils.buildToken(templateTokenName, idx), matcher.group(idx));
                    }
                }
            }
            return isMatch;
        }
        catch (PatternSyntaxException e) {
            return stubbedValue.equals(assertingValue);
        }
    }

    @VisibleForTesting
    boolean arraysIntersect(ArrayList<String> stubbedArray, ArrayList<String> assertingArray) {
        if (stubbedArray.isEmpty()) {
            return true;
        }
        if (!assertingArray.isEmpty()) {
            for (String entry : assertingArray) {
                if (!stubbedArray.contains(entry)) continue;
                return true;
            }
        }
        return false;
    }

    @CoberturaIgnore
    public int hashCode() {
        int result = ObjectUtils.isNotNull(this.url) ? this.url.hashCode() : 0;
        result = 31 * result + this.method.hashCode();
        result = 31 * result + (ObjectUtils.isNotNull(this.post) ? this.post.hashCode() : 0);
        result = 31 * result + (ObjectUtils.isNotNull(this.fileBytes) && this.fileBytes.length != 0 ? Arrays.hashCode(this.fileBytes) : 0);
        result = 31 * result + this.headers.hashCode();
        result = 31 * result + this.query.hashCode();
        return result;
    }

    @CoberturaIgnore
    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("StubRequest");
        sb.append("{url=").append(this.url);
        sb.append(", method=").append(this.method);
        if (!ObjectUtils.isNull(this.post)) {
            sb.append(", post=").append(this.post);
        }
        sb.append(", query=").append(this.query);
        sb.append(", headers=").append(this.getHeaders());
        sb.append('}');
        return sb.toString();
    }
}

