/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.Dispatcher;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject(value="Push cache based on the HTTP 'Referer' header")
public class PushCacheFilter
implements Filter {
    private static final Logger LOG = Log.getLogger(PushCacheFilter.class);
    private final Set<Integer> _ports = new HashSet<Integer>();
    private final Set<String> _hosts = new HashSet<String>();
    private final ConcurrentMap<String, PrimaryResource> _cache = new ConcurrentHashMap<String, PrimaryResource>();
    private long _associatePeriod = 4000L;
    private int _maxAssociations = 16;
    private long _renew = System.nanoTime();

    @Override
    public void init(FilterConfig config) throws ServletException {
        String ports;
        String hosts;
        String maxAssociations;
        String associatePeriod = config.getInitParameter("associatePeriod");
        if (associatePeriod != null) {
            this._associatePeriod = Long.parseLong(associatePeriod);
        }
        if ((maxAssociations = config.getInitParameter("maxAssociations")) != null) {
            this._maxAssociations = Integer.parseInt(maxAssociations);
        }
        if ((hosts = config.getInitParameter("hosts")) != null) {
            Collections.addAll(this._hosts, StringUtil.csvSplit(hosts));
        }
        if ((ports = config.getInitParameter("ports")) != null) {
            for (String p : StringUtil.csvSplit(ports)) {
                this._ports.add(Integer.parseInt(p));
            }
        }
        config.getServletContext().setAttribute(config.getFilterName(), this);
        if (LOG.isDebugEnabled()) {
            LOG.debug("period={} max={} hosts={} ports={}", this._associatePeriod, this._maxAssociations, this._hosts, this._ports);
        }
    }

    @Override
    public void doFilter(ServletRequest req, ServletResponse resp, FilterChain chain) throws IOException, ServletException {
        PrimaryResource primaryResource;
        if (HttpVersion.fromString(req.getProtocol()).getVersion() < 20) {
            chain.doFilter(req, resp);
            return;
        }
        long now = System.nanoTime();
        HttpServletRequest request = (HttpServletRequest)req;
        HttpFields fields = Request.getBaseRequest(request).getHttpFields();
        boolean conditional = false;
        String referrer = null;
        block4: for (int i = 0; i < fields.size(); ++i) {
            HttpField field = fields.getField(i);
            HttpHeader header = field.getHeader();
            if (header == null) continue;
            switch (header) {
                case IF_MATCH: 
                case IF_MODIFIED_SINCE: 
                case IF_NONE_MATCH: 
                case IF_UNMODIFIED_SINCE: {
                    conditional = true;
                    break block4;
                }
                case REFERER: {
                    referrer = field.getValue();
                }
                default: {
                    continue block4;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} {} referrer={} conditional={} synthetic={}", request.getMethod(), request.getRequestURI(), referrer, conditional, this.isPushRequest(request));
        }
        String path = URIUtil.addPaths(request.getServletPath(), request.getPathInfo());
        String query = request.getQueryString();
        if (query != null) {
            path = path + "?" + query;
        }
        if (referrer != null) {
            boolean referredFromHere;
            HttpURI referrerURI = new HttpURI(referrer);
            String host = referrerURI.getHost();
            int port = referrerURI.getPort();
            if (port <= 0) {
                port = request.isSecure() ? 443 : 80;
            }
            boolean bl = referredFromHere = this._hosts.size() > 0 ? this._hosts.contains(host) : host.equals(request.getServerName());
            if (referredFromHere &= this._ports.size() > 0 ? this._ports.contains(port) : port == request.getServerPort()) {
                if ("GET".equalsIgnoreCase(request.getMethod())) {
                    String referrerPath = referrerURI.getPath();
                    if (referrerPath == null) {
                        referrerPath = "/";
                    }
                    if (referrerPath.startsWith(request.getContextPath())) {
                        String referrerPathNoContext = referrerPath.substring(request.getContextPath().length());
                        if (!referrerPathNoContext.equals(path)) {
                            long primaryTimestamp;
                            PrimaryResource primaryResource2 = (PrimaryResource)this._cache.get(referrerPathNoContext);
                            if (primaryResource2 != null && (primaryTimestamp = primaryResource2._timestamp.get()) != 0L) {
                                RequestDispatcher dispatcher = request.getServletContext().getRequestDispatcher(path);
                                if (now - primaryTimestamp < TimeUnit.MILLISECONDS.toNanos(this._associatePeriod)) {
                                    ConcurrentMap associated = primaryResource2._associated;
                                    if (associated.size() <= this._maxAssociations) {
                                        if (associated.putIfAbsent(path, dispatcher) == null && LOG.isDebugEnabled()) {
                                            LOG.debug("Associated {} to {}", path, referrerPathNoContext);
                                        }
                                    } else if (LOG.isDebugEnabled()) {
                                        LOG.debug("Not associated {} to {}, exceeded max associations of {}", path, referrerPathNoContext, this._maxAssociations);
                                    }
                                } else if (LOG.isDebugEnabled()) {
                                    LOG.debug("Not associated {} to {}, outside associate period of {}ms", path, referrerPathNoContext, this._associatePeriod);
                                }
                            }
                        } else if (LOG.isDebugEnabled()) {
                            LOG.debug("Not associated {} to {}, referring to self", path, referrerPathNoContext);
                        }
                    }
                }
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("External referrer {}", referrer);
            }
        }
        if ((primaryResource = (PrimaryResource)this._cache.get(path)) == null) {
            PrimaryResource r = new PrimaryResource();
            primaryResource = this._cache.putIfAbsent(path, r);
            primaryResource = primaryResource == null ? r : primaryResource;
            primaryResource._timestamp.compareAndSet(0L, now);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cached primary resource {}", path);
            }
        } else {
            long last = primaryResource._timestamp.get();
            if (last < this._renew && primaryResource._timestamp.compareAndSet(last, now)) {
                primaryResource._associated.clear();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Clear associated resources for {}", path);
                }
            }
        }
        if (!(this.isPushRequest(request) || conditional || primaryResource._associated.isEmpty())) {
            ArrayDeque<PrimaryResource> queue = new ArrayDeque<PrimaryResource>();
            queue.offer(primaryResource);
            while (!queue.isEmpty()) {
                PrimaryResource parent = (PrimaryResource)queue.poll();
                for (Map.Entry entry : parent._associated.entrySet()) {
                    PrimaryResource child = (PrimaryResource)this._cache.get(entry.getKey());
                    if (child != null) {
                        queue.offer(child);
                    }
                    Dispatcher dispatcher = (Dispatcher)entry.getValue();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Pushing {} for {}", dispatcher, path);
                    }
                    dispatcher.push(request);
                }
            }
        }
        chain.doFilter(request, resp);
    }

    private boolean isPushRequest(HttpServletRequest request) {
        return Boolean.TRUE.equals(request.getAttribute("org.eclipse.jetty.pushed"));
    }

    @Override
    public void destroy() {
        this.clearPushCache();
    }

    @ManagedAttribute(value="The push cache contents")
    public Map<String, String> getPushCache() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : this._cache.entrySet()) {
            PrimaryResource resource = (PrimaryResource)entry.getValue();
            String value = String.format("size=%d: %s", resource._associated.size(), new TreeSet(resource._associated.keySet()));
            result.put((String)entry.getKey(), value);
        }
        return result;
    }

    @ManagedOperation(value="Renews the push cache contents", impact="ACTION")
    public void renewPushCache() {
        this._renew = System.nanoTime();
    }

    @ManagedOperation(value="Clears the push cache contents", impact="ACTION")
    public void clearPushCache() {
        this._cache.clear();
    }

    private static class PrimaryResource {
        private final ConcurrentMap<String, RequestDispatcher> _associated = new ConcurrentHashMap<String, RequestDispatcher>();
        private final AtomicLong _timestamp = new AtomicLong();

        private PrimaryResource() {
        }
    }
}

