/*
 * Decompiled with CFR 0.152.
 */
package io.github.cbartosiak.bson.codecs.jsr310.duration;

import io.github.cbartosiak.bson.codecs.jsr310.internal.CodecsUtil;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.Objects;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.types.Decimal128;

public final class DurationAsDecimal128Codec
implements Codec<Duration> {
    public void encode(BsonWriter writer, Duration value, EncoderContext encoderContext) {
        Objects.requireNonNull(writer, "writer is null");
        Objects.requireNonNull(value, "value is null");
        CodecsUtil.translateEncodeExceptions(() -> value, val -> writer.writeDecimal128(Decimal128.parse((String)String.format("%d.%09d", val.getSeconds(), val.getNano()))));
    }

    public Duration decode(BsonReader reader, DecoderContext decoderContext) {
        Objects.requireNonNull(reader, "reader is null");
        return CodecsUtil.translateDecodeExceptions(() -> ((BsonReader)reader).readDecimal128(), val -> {
            BigDecimal bigDecimal = val.bigDecimalValue();
            long seconds = bigDecimal.longValue();
            int nanos = bigDecimal.subtract(new BigDecimal(seconds)).scaleByPowerOfTen(9).abs().intValue();
            return Duration.ofSeconds(seconds, nanos);
        });
    }

    public Class<Duration> getEncoderClass() {
        return Duration.class;
    }
}

