/*
 * Decompiled with CFR 0.152.
 */
package io.github.cbartosiak.bson.codecs.jsr310.instant;

import io.github.cbartosiak.bson.codecs.jsr310.internal.CodecsUtil;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public final class InstantAsDocumentCodec
implements Codec<Instant> {
    private static final Map<String, Decoder<?>> FIELD_DECODERS;

    public void encode(BsonWriter writer, Instant value, EncoderContext encoderContext) {
        Objects.requireNonNull(writer, "writer is null");
        Objects.requireNonNull(value, "value is null");
        writer.writeStartDocument();
        writer.writeInt64("seconds", value.getEpochSecond());
        writer.writeInt32("nanos", value.getNano());
        writer.writeEndDocument();
    }

    public Instant decode(BsonReader reader, DecoderContext decoderContext) {
        Objects.requireNonNull(reader, "reader is null");
        return CodecsUtil.translateDecodeExceptions(() -> CodecsUtil.readDocument(reader, decoderContext, FIELD_DECODERS), val -> Instant.ofEpochSecond(CodecsUtil.getFieldValue(val, "seconds", Long.class), CodecsUtil.getFieldValue(val, "nanos", Integer.class).intValue()));
    }

    public Class<Instant> getEncoderClass() {
        return Instant.class;
    }

    static {
        HashMap<String, Decoder> fd = new HashMap<String, Decoder>();
        fd.put("seconds", (r, dc) -> r.readInt64());
        fd.put("nanos", (r, dc) -> r.readInt32());
        FIELD_DECODERS = Collections.unmodifiableMap(fd);
    }
}

