/*
 * Decompiled with CFR 0.152.
 */
package io.github.cbartosiak.bson.codecs.jsr310.internal;

import java.time.DateTimeException;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.Document;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;

public final class CodecsUtil {
    private CodecsUtil() {
    }

    public static <Value> void translateEncodeExceptions(Supplier<Value> valueSupplier, Consumer<Value> valueConsumer) {
        Value value = valueSupplier.get();
        try {
            valueConsumer.accept(value);
        }
        catch (ArithmeticException | NumberFormatException | DateTimeException ex) {
            throw new BsonInvalidOperationException(String.format("The value %s is not supported", value), (Throwable)ex);
        }
    }

    public static <Value, Result> Result translateDecodeExceptions(Supplier<Value> valueSupplier, Function<Value, Result> valueConverter) {
        Value value = valueSupplier.get();
        try {
            return valueConverter.apply(value);
        }
        catch (ArithmeticException | IllegalArgumentException | DateTimeException ex) {
            throw new BsonInvalidOperationException(String.format("The value %s is not supported", value), (Throwable)ex);
        }
    }

    public static Document readDocument(BsonReader reader, DecoderContext decoderContext, Map<String, Decoder<?>> fieldDecoders) {
        Document document = new Document();
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = reader.readName();
            if (fieldDecoders.containsKey(fieldName)) {
                document.put(fieldName, fieldDecoders.get(fieldName).decode(reader, decoderContext));
                continue;
            }
            throw new BsonInvalidOperationException(String.format("The field %s is not expected here", fieldName));
        }
        reader.readEndDocument();
        return document;
    }

    public static <Value> Value getFieldValue(Document document, Object key, Class<Value> clazz) {
        try {
            Object value = document.get(key, clazz);
            if (value == null) {
                throw new BsonInvalidOperationException(String.format("The value of the field %s is null", key));
            }
            return (Value)value;
        }
        catch (ClassCastException ex) {
            throw new BsonInvalidOperationException(String.format("The value of the field %s is not of the type %s", key, clazz.getName()), (Throwable)ex);
        }
    }
}

