/*
 * Decompiled with CFR 0.152.
 */
package io.github.cbartosiak.bson.codecs.jsr310.localdate;

import io.github.cbartosiak.bson.codecs.jsr310.internal.CodecsUtil;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Objects;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public final class LocalDateAsDateTimeCodec
implements Codec<LocalDate> {
    public void encode(BsonWriter writer, LocalDate value, EncoderContext encoderContext) {
        Objects.requireNonNull(writer, "writer is null");
        Objects.requireNonNull(value, "value is null");
        CodecsUtil.translateEncodeExceptions(() -> value, val -> writer.writeDateTime(val.atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli()));
    }

    public LocalDate decode(BsonReader reader, DecoderContext decoderContext) {
        Objects.requireNonNull(reader, "reader is null");
        return CodecsUtil.translateDecodeExceptions(() -> ((BsonReader)reader).readDateTime(), val -> Instant.ofEpochMilli(val).atOffset(ZoneOffset.UTC).toLocalDate());
    }

    public Class<LocalDate> getEncoderClass() {
        return LocalDate.class;
    }
}

