/*
 * Decompiled with CFR 0.152.
 */
package io.github.cbartosiak.bson.codecs.jsr310.localdatetime;

import io.github.cbartosiak.bson.codecs.jsr310.internal.CodecsUtil;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Objects;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public final class LocalDateTimeAsDateTimeCodec
implements Codec<LocalDateTime> {
    public void encode(BsonWriter writer, LocalDateTime value, EncoderContext encoderContext) {
        Objects.requireNonNull(writer, "writer is null");
        Objects.requireNonNull(value, "value is null");
        CodecsUtil.translateEncodeExceptions(() -> value, val -> writer.writeDateTime(val.toInstant(ZoneOffset.UTC).toEpochMilli()));
    }

    public LocalDateTime decode(BsonReader reader, DecoderContext decoderContext) {
        Objects.requireNonNull(reader, "reader is null");
        return CodecsUtil.translateDecodeExceptions(() -> ((BsonReader)reader).readDateTime(), val -> Instant.ofEpochMilli(val).atOffset(ZoneOffset.UTC).toLocalDateTime());
    }

    public Class<LocalDateTime> getEncoderClass() {
        return LocalDateTime.class;
    }
}

