/*
 * Decompiled with CFR 0.152.
 */
package io.github.cbartosiak.bson.codecs.jsr310.localtime;

import io.github.cbartosiak.bson.codecs.jsr310.internal.CodecsUtil;
import java.time.LocalTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public final class LocalTimeAsDocumentCodec
implements Codec<LocalTime> {
    private static final Map<String, Decoder<?>> FIELD_DECODERS;

    public void encode(BsonWriter writer, LocalTime value, EncoderContext encoderContext) {
        Objects.requireNonNull(writer, "writer is null");
        Objects.requireNonNull(value, "value is null");
        writer.writeStartDocument();
        writer.writeInt32("hour", value.getHour());
        writer.writeInt32("minute", value.getMinute());
        writer.writeInt32("second", value.getSecond());
        writer.writeInt32("nano", value.getNano());
        writer.writeEndDocument();
    }

    public LocalTime decode(BsonReader reader, DecoderContext decoderContext) {
        Objects.requireNonNull(reader, "reader is null");
        return CodecsUtil.translateDecodeExceptions(() -> CodecsUtil.readDocument(reader, decoderContext, FIELD_DECODERS), val -> LocalTime.of(CodecsUtil.getFieldValue(val, "hour", Integer.class), CodecsUtil.getFieldValue(val, "minute", Integer.class), CodecsUtil.getFieldValue(val, "second", Integer.class), CodecsUtil.getFieldValue(val, "nano", Integer.class)));
    }

    public Class<LocalTime> getEncoderClass() {
        return LocalTime.class;
    }

    static {
        HashMap<String, Decoder> fd = new HashMap<String, Decoder>();
        fd.put("hour", (r, dc) -> r.readInt32());
        fd.put("minute", (r, dc) -> r.readInt32());
        fd.put("second", (r, dc) -> r.readInt32());
        fd.put("nano", (r, dc) -> r.readInt32());
        FIELD_DECODERS = Collections.unmodifiableMap(fd);
    }
}

