/*
 * Decompiled with CFR 0.152.
 */
package io.github.cbartosiak.bson.codecs.jsr310.offsetdatetime;

import io.github.cbartosiak.bson.codecs.jsr310.internal.CodecsUtil;
import io.github.cbartosiak.bson.codecs.jsr310.localdatetime.LocalDateTimeAsDocumentCodec;
import io.github.cbartosiak.bson.codecs.jsr310.zoneoffset.ZoneOffsetAsInt32Codec;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public final class OffsetDateTimeAsDocumentCodec
implements Codec<OffsetDateTime> {
    private final Codec<LocalDateTime> localDateTimeCodec;
    private final Codec<ZoneOffset> zoneOffsetCodec;
    private final Map<String, Decoder<?>> fieldDecoders;

    public OffsetDateTimeAsDocumentCodec() {
        this(new LocalDateTimeAsDocumentCodec(), new ZoneOffsetAsInt32Codec());
    }

    public OffsetDateTimeAsDocumentCodec(Codec<LocalDateTime> localDateTimeCodec, Codec<ZoneOffset> zoneOffsetCodec) {
        this.localDateTimeCodec = Objects.requireNonNull(localDateTimeCodec, "localDateTimeCodec is null");
        this.zoneOffsetCodec = Objects.requireNonNull(zoneOffsetCodec, "zoneOffsetCodec is null");
        HashMap<String, Decoder> fd = new HashMap<String, Decoder>();
        fd.put("dateTime", (arg_0, arg_1) -> localDateTimeCodec.decode(arg_0, arg_1));
        fd.put("offset", (arg_0, arg_1) -> zoneOffsetCodec.decode(arg_0, arg_1));
        this.fieldDecoders = Collections.unmodifiableMap(fd);
    }

    public void encode(BsonWriter writer, OffsetDateTime value, EncoderContext encoderContext) {
        Objects.requireNonNull(writer, "writer is null");
        Objects.requireNonNull(value, "value is null");
        writer.writeStartDocument();
        writer.writeName("dateTime");
        this.localDateTimeCodec.encode(writer, (Object)value.toLocalDateTime(), encoderContext);
        writer.writeName("offset");
        this.zoneOffsetCodec.encode(writer, (Object)value.getOffset(), encoderContext);
        writer.writeEndDocument();
    }

    public OffsetDateTime decode(BsonReader reader, DecoderContext decoderContext) {
        Objects.requireNonNull(reader, "reader is null");
        return CodecsUtil.translateDecodeExceptions(() -> CodecsUtil.readDocument(reader, decoderContext, this.fieldDecoders), val -> OffsetDateTime.of(CodecsUtil.getFieldValue(val, "dateTime", LocalDateTime.class), CodecsUtil.getFieldValue(val, "offset", ZoneOffset.class)));
    }

    public Class<OffsetDateTime> getEncoderClass() {
        return OffsetDateTime.class;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        OffsetDateTimeAsDocumentCodec rhs = (OffsetDateTimeAsDocumentCodec)obj;
        return this.localDateTimeCodec.equals(rhs.localDateTimeCodec) && this.zoneOffsetCodec.equals(rhs.zoneOffsetCodec) && this.fieldDecoders.equals(rhs.fieldDecoders);
    }

    public int hashCode() {
        int result = this.localDateTimeCodec.hashCode();
        result = 31 * result + this.zoneOffsetCodec.hashCode();
        result = 31 * result + this.fieldDecoders.hashCode();
        return result;
    }

    public String toString() {
        return "OffsetDateTimeAsDocumentCodec[localDateTimeCodec=" + this.localDateTimeCodec + ",zoneOffsetCodec=" + this.zoneOffsetCodec + ",fieldDecoders=" + this.fieldDecoders + ']';
    }
}

