/*
 * Decompiled with CFR 0.152.
 */
package io.github.cbartosiak.bson.codecs.jsr310.yearmonth;

import io.github.cbartosiak.bson.codecs.jsr310.internal.CodecsUtil;
import java.math.BigDecimal;
import java.time.YearMonth;
import java.util.Objects;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.types.Decimal128;

public final class YearMonthAsDecimal128Codec
implements Codec<YearMonth> {
    public void encode(BsonWriter writer, YearMonth value, EncoderContext encoderContext) {
        Objects.requireNonNull(writer, "writer is null");
        Objects.requireNonNull(value, "value is null");
        CodecsUtil.translateEncodeExceptions(() -> value, val -> writer.writeDecimal128(Decimal128.parse((String)String.format("%d.%02d", val.getYear(), val.getMonthValue()))));
    }

    public YearMonth decode(BsonReader reader, DecoderContext decoderContext) {
        Objects.requireNonNull(reader, "reader is null");
        return CodecsUtil.translateDecodeExceptions(() -> ((BsonReader)reader).readDecimal128(), val -> {
            BigDecimal bigDecimal = val.bigDecimalValue();
            int year = bigDecimal.intValue();
            int month = bigDecimal.subtract(new BigDecimal(year)).scaleByPowerOfTen(2).abs().intValue();
            return YearMonth.of(year, month);
        });
    }

    public Class<YearMonth> getEncoderClass() {
        return YearMonth.class;
    }
}

