/*
 * Decompiled with CFR 0.152.
 */
package io.github.cbartosiak.bson.codecs.jsr310.zoneddatetime;

import io.github.cbartosiak.bson.codecs.jsr310.internal.CodecsUtil;
import io.github.cbartosiak.bson.codecs.jsr310.localdatetime.LocalDateTimeAsDocumentCodec;
import io.github.cbartosiak.bson.codecs.jsr310.zoneid.ZoneIdAsStringCodec;
import io.github.cbartosiak.bson.codecs.jsr310.zoneoffset.ZoneOffsetAsInt32Codec;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.Decoder;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public final class ZonedDateTimeAsDocumentCodec
implements Codec<ZonedDateTime> {
    private final Codec<LocalDateTime> localDateTimeCodec;
    private final Codec<ZoneOffset> zoneOffsetCodec;
    private final Codec<ZoneId> zoneIdCodec;
    private final Map<String, Decoder<?>> fieldDecoders;

    public ZonedDateTimeAsDocumentCodec() {
        this(new LocalDateTimeAsDocumentCodec(), new ZoneOffsetAsInt32Codec(), new ZoneIdAsStringCodec());
    }

    public ZonedDateTimeAsDocumentCodec(Codec<LocalDateTime> localDateTimeCodec, Codec<ZoneOffset> zoneOffsetCodec, Codec<ZoneId> zoneIdCodec) {
        this.localDateTimeCodec = Objects.requireNonNull(localDateTimeCodec, "localDateTimeCodec is null");
        this.zoneOffsetCodec = Objects.requireNonNull(zoneOffsetCodec, "zoneOffsetCodec is null");
        this.zoneIdCodec = Objects.requireNonNull(zoneIdCodec, "zoneIdCodec is null");
        HashMap<String, Decoder> fd = new HashMap<String, Decoder>();
        fd.put("dateTime", (arg_0, arg_1) -> localDateTimeCodec.decode(arg_0, arg_1));
        fd.put("offset", (arg_0, arg_1) -> zoneOffsetCodec.decode(arg_0, arg_1));
        fd.put("zone", (arg_0, arg_1) -> zoneIdCodec.decode(arg_0, arg_1));
        this.fieldDecoders = Collections.unmodifiableMap(fd);
    }

    public void encode(BsonWriter writer, ZonedDateTime value, EncoderContext encoderContext) {
        Objects.requireNonNull(writer, "writer is null");
        Objects.requireNonNull(value, "value is null");
        writer.writeStartDocument();
        writer.writeName("dateTime");
        this.localDateTimeCodec.encode(writer, (Object)value.toLocalDateTime(), encoderContext);
        writer.writeName("offset");
        this.zoneOffsetCodec.encode(writer, (Object)value.getOffset(), encoderContext);
        writer.writeName("zone");
        this.zoneIdCodec.encode(writer, (Object)value.getZone(), encoderContext);
        writer.writeEndDocument();
    }

    public ZonedDateTime decode(BsonReader reader, DecoderContext decoderContext) {
        Objects.requireNonNull(reader, "reader is null");
        return CodecsUtil.translateDecodeExceptions(() -> CodecsUtil.readDocument(reader, decoderContext, this.fieldDecoders), val -> ZonedDateTime.ofStrict(CodecsUtil.getFieldValue(val, "dateTime", LocalDateTime.class), CodecsUtil.getFieldValue(val, "offset", ZoneOffset.class), CodecsUtil.getFieldValue(val, "zone", ZoneId.class)));
    }

    public Class<ZonedDateTime> getEncoderClass() {
        return ZonedDateTime.class;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ZonedDateTimeAsDocumentCodec rhs = (ZonedDateTimeAsDocumentCodec)obj;
        return this.localDateTimeCodec.equals(rhs.localDateTimeCodec) && this.zoneOffsetCodec.equals(rhs.zoneOffsetCodec) && this.zoneIdCodec.equals(rhs.zoneIdCodec) && this.fieldDecoders.equals(rhs.fieldDecoders);
    }

    public int hashCode() {
        int result = this.localDateTimeCodec.hashCode();
        result = 31 * result + this.zoneOffsetCodec.hashCode();
        result = 31 * result + this.zoneIdCodec.hashCode();
        result = 31 * result + this.fieldDecoders.hashCode();
        return result;
    }

    public String toString() {
        return "ZonedDateTimeAsDocumentCodec[localDateTimeCodec=" + this.localDateTimeCodec + ",zoneOffsetCodec=" + this.zoneOffsetCodec + ",zoneIdCodec=" + this.zoneIdCodec + ",fieldDecoders=" + this.fieldDecoders + ']';
    }
}

