/*
 * Decompiled with CFR 0.152.
 */
package io.github.cbartosiak.bson.codecs.jsr310.zoneid;

import io.github.cbartosiak.bson.codecs.jsr310.internal.CodecsUtil;
import java.time.ZoneId;
import java.util.Objects;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public final class ZoneIdAsStringCodec
implements Codec<ZoneId> {
    public void encode(BsonWriter writer, ZoneId value, EncoderContext encoderContext) {
        Objects.requireNonNull(writer, "writer is null");
        Objects.requireNonNull(value, "value is null");
        writer.writeString(value.getId());
    }

    public ZoneId decode(BsonReader reader, DecoderContext decoderContext) {
        Objects.requireNonNull(reader, "reader is null");
        return CodecsUtil.translateDecodeExceptions(() -> ((BsonReader)reader).readString(), ZoneId::of);
    }

    public Class<ZoneId> getEncoderClass() {
        return ZoneId.class;
    }
}

