/*
 * Decompiled with CFR 0.152.
 */
package io.github.dengliming.redismodule.redisgears;

import io.github.dengliming.redismodule.common.util.RAssert;
import io.github.dengliming.redismodule.redisgears.model.ClusterInfo;
import io.github.dengliming.redismodule.redisgears.protocol.Keywords;
import io.github.dengliming.redismodule.redisgears.protocol.RedisCommands;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.command.CommandAsyncExecutor;

public class RedisGears {
    private final CommandAsyncExecutor commandExecutor;
    private final Codec codec;

    public RedisGears(CommandAsyncExecutor commandExecutor) {
        this(commandExecutor, (Codec)StringCodec.INSTANCE);
    }

    public RedisGears(CommandAsyncExecutor commandExecutor, Codec codec) {
        this.commandExecutor = commandExecutor;
        this.codec = codec;
    }

    public Object pyExecute(String function, boolean unBlocking, String ... requirements) {
        return this.commandExecutor.get(this.pyExecuteAsync(function, unBlocking, requirements));
    }

    public RFuture<Object> pyExecuteAsync(String function, boolean unBlocking, String ... requirements) {
        RAssert.notEmpty((CharSequence)function, (String)"function must not be empty");
        ArrayList<Object> args = new ArrayList<Object>();
        args.add("" + function + "");
        if (unBlocking) {
            args.add((Object)Keywords.UNBLOCKING);
        }
        if (requirements.length > 0) {
            args.add((Object)Keywords.REQUIREMENTS);
            args.add("\"" + String.join((CharSequence)" ", requirements) + "\"");
        }
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.RG_PYEXECUTE, args.toArray());
    }

    public List<String> getConfig(String ... keys) {
        return (List)this.commandExecutor.get(this.getConfigAsync(keys));
    }

    public RFuture<List<String>> getConfigAsync(String ... keys) {
        RAssert.notEmpty((Object[])keys, (String)"keys must not be empty");
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.RG_CONFIGGET, (Object[])keys);
    }

    public List<String> setConfig(Map<String, String> kvs) {
        return (List)this.commandExecutor.get(this.setConfigAsync(kvs));
    }

    public RFuture<List<String>> setConfigAsync(Map<String, String> kvs) {
        RAssert.notEmpty(kvs, (String)"kvs must not be empty");
        ArrayList args = new ArrayList(kvs.size());
        kvs.forEach((k, v) -> {
            args.add(k);
            args.add(v);
        });
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.RG_CONFIGSET, args.toArray());
    }

    public Map<String, Object> pyStats() {
        return (Map)this.commandExecutor.get(this.pyStatsAsync());
    }

    public RFuture<Map<String, Object>> pyStatsAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.RG_PYSTATS, new Object[0]);
    }

    public Boolean unRegister(String id) {
        return (Boolean)this.commandExecutor.get(this.unRegisterAsync(id));
    }

    public RFuture<Boolean> unRegisterAsync(String id) {
        RAssert.notEmpty((CharSequence)id, (String)"id must not be empty");
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.RG_UNREGISTER, new Object[]{id});
    }

    public Boolean refreshCluster() {
        return (Boolean)this.commandExecutor.get(this.refreshClusterAsync());
    }

    public RFuture<Boolean> refreshClusterAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.RG_REFRESHCLUSTER, new Object[0]);
    }

    public Boolean abortExecution(String id) {
        return (Boolean)this.commandExecutor.get(this.abortExecutionAsync(id));
    }

    public RFuture<Boolean> abortExecutionAsync(String id) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.RG_ABORTEXECUTION, new Object[]{id});
    }

    public Boolean dropExecution(String id) {
        return (Boolean)this.commandExecutor.get(this.dropExecutionAsync(id));
    }

    public RFuture<Boolean> dropExecutionAsync(String id) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.RG_DROPEXECUTION, new Object[]{id});
    }

    public ClusterInfo clusterInfo() {
        return (ClusterInfo)this.commandExecutor.get(this.clusterInfoAsync());
    }

    public RFuture<ClusterInfo> clusterInfoAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.RG_INFOCLUSTER, new Object[0]);
    }

    public String getName() {
        return "";
    }
}

