/*
 * Decompiled with CFR 0.152.
 */
package io.github.dengliming.redismodule.redisgears.protocol.decoder;

import io.github.dengliming.redismodule.redisgears.model.ClusterInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class ClusterInfoDecoder
implements MultiDecoder<ClusterInfo> {
    public ClusterInfo decode(List<Object> parts, State state) {
        if (parts.size() < 5) {
            return null;
        }
        List shards = (List)parts.get(4);
        return new ClusterInfo((String)parts.get(1), (String)parts.get(3), shards.stream().map(it -> this.buildShard((List<Object>)it)).collect(Collectors.toList()));
    }

    private ClusterInfo.Shard buildShard(List<Object> shardFields) {
        ClusterInfo.Shard shard = new ClusterInfo.Shard();
        block18: for (int i = 0; i < shardFields.size(); i += 2) {
            Object v = shardFields.get(i + 1);
            switch ((String)shardFields.get(i)) {
                case "id": {
                    shard.setId(v.toString());
                    continue block18;
                }
                case "ip": {
                    shard.setIp(v.toString());
                    continue block18;
                }
                case "port": {
                    shard.setPort(Integer.parseInt(v.toString()));
                    continue block18;
                }
                case "unixSocket": {
                    shard.setUnixSocket(v.toString());
                    continue block18;
                }
                case "runid": {
                    shard.setRunId(v.toString());
                    continue block18;
                }
                case "minHslot": {
                    shard.setMinHslot(Integer.parseInt(v.toString()));
                    continue block18;
                }
                case "maxHslot": {
                    shard.setMaxHslot(Integer.parseInt(v.toString()));
                    continue block18;
                }
            }
        }
        return shard;
    }
}

