/*
 * Decompiled with CFR 0.152.
 */
package io.github.hengyunabc.zabbix.sender;

import com.alibaba.fastjson.JSON;

public class DataObject {
    long clock;
    String host;
    String key;
    String value;

    public DataObject() {
    }

    public DataObject(long clock, String host, String key, String value) {
        this.clock = clock;
        this.host = host;
        this.key = key;
        this.value = value;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long getClock() {
        return this.clock;
    }

    public void setClock(long clock) {
        this.clock = clock;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String toString() {
        return JSON.toJSONString((Object)this);
    }

    public static class Builder {
        Long clock;
        String host;
        String key;
        String value;

        Builder() {
        }

        public Builder clock(long clock) {
            this.clock = clock;
            return this;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder key(String key) {
            this.key = key;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public DataObject build() {
            if (this.clock == null) {
                this.clock = System.currentTimeMillis() / 1000L;
            }
            return new DataObject(this.clock, this.host, this.key, this.value);
        }
    }
}

