/*
 * Decompiled with CFR 0.152.
 */
package io.github.kbuntrock.utils;

public enum ParameterLocation {
    PATH("path"),
    QUERY("query"),
    BODY("body"),
    HEADER("header"),
    BODY_PART("body_part"),
    COOKIE("cookie");

    private String value;

    private ParameterLocation(String value) {
        if (value == null) {
            value = "";
        }
        this.value = value.trim().toLowerCase();
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ParameterLocation fromValue(String value) {
        if (value == null) {
            return QUERY;
        }
        String normalized = value.trim().toLowerCase();
        for (ParameterLocation loc : ParameterLocation.values()) {
            if (!loc.value.equals(normalized)) continue;
            return loc;
        }
        return QUERY;
    }
}

