/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter;

import io.github.liquibaselinter.config.RuleConfig;
import java.util.Optional;
import liquibase.Contexts;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;

final class ConditionHelper {
    private ConditionHelper() {
    }

    public static boolean evaluateCondition(RuleConfig ruleConfig, Change change) {
        return ruleConfig.getConditionalExpression().map(expression -> (Boolean)expression.getValue((Object)ConditionContext.from(change), Boolean.TYPE)).orElse(true);
    }

    public static boolean evaluateCondition(RuleConfig ruleConfig, ChangeSet changeSet) {
        return ruleConfig.getConditionalExpression().map(expression -> (Boolean)expression.getValue((Object)ConditionContext.from(changeSet), Boolean.TYPE)).orElse(true);
    }

    public static boolean evaluateCondition(RuleConfig ruleConfig, DatabaseChangeLog databaseChangeLog) {
        return ruleConfig.getConditionalExpression().map(expression -> (Boolean)expression.getValue((Object)ConditionContext.from(databaseChangeLog), Boolean.TYPE)).orElse(true);
    }

    private static final class ConditionContext {
        private final DatabaseChangeLog changeLog;
        private final ChangeSet changeSet;
        private final Change change;

        private ConditionContext(DatabaseChangeLog changeLog, ChangeSet changeSet, Change change) {
            this.changeLog = changeLog;
            this.changeSet = changeSet;
            this.change = change;
        }

        private static ConditionContext from(Change change) {
            return new ConditionContext(change.getChangeSet().getChangeLog(), change.getChangeSet(), change);
        }

        private static ConditionContext from(ChangeSet changeSet) {
            return new ConditionContext(changeSet.getChangeLog(), changeSet, null);
        }

        private static ConditionContext from(DatabaseChangeLog changeLog) {
            return new ConditionContext(changeLog, null, null);
        }

        public DatabaseChangeLog getChangeLog() {
            return this.changeLog;
        }

        public ChangeSet getChangeSet() {
            return this.changeSet;
        }

        public Change getChange() {
            return this.change;
        }

        public boolean matchesContext(String ... toMatch) {
            return Optional.ofNullable(this.changeSet).map(ChangeSet::getContextFilter).map(contexts -> !contexts.isEmpty() && contexts.matches(new Contexts(toMatch))).orElse(false);
        }
    }
}

