/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.report;

import com.google.auto.service.AutoService;
import io.github.liquibaselinter.report.AbstractReporter;
import io.github.liquibaselinter.report.EmptyLastComparator;
import io.github.liquibaselinter.report.Report;
import io.github.liquibaselinter.report.ReportItem;
import io.github.liquibaselinter.report.Reporter;
import io.github.liquibaselinter.report.ReporterConfig;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class TextReporter
extends AbstractReporter {
    public static final String NAME = "text";

    public TextReporter(ReporterConfig config) {
        this(config, "txt");
    }

    protected TextReporter(ReporterConfig config, String defaultPathExtension) {
        super(config, defaultPathExtension);
    }

    @Override
    protected void printReport(PrintWriter output, Report report, List<ReportItem> items) {
        this.printByChangeLogFile(output, items);
        this.printSummary(output, report);
    }

    protected void printByChangeLogFile(PrintWriter output, List<ReportItem> items) {
        items.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getFilePath()).map(String::trim).orElse(""))).entrySet().stream().sorted(Map.Entry.comparingByKey(new EmptyLastComparator())).forEach(entry -> this.printChangeLogFile(output, (String)entry.getKey(), (List)entry.getValue()));
    }

    protected void printChangeLogFile(PrintWriter output, String fileName, List<ReportItem> items) {
        this.printChangeLogHeader(output, fileName);
        this.printByChangeSet(output, items);
        output.println();
    }

    protected void printChangeLogHeader(PrintWriter output, String fileName) {
        if (StringUtils.isEmpty((CharSequence)fileName)) {
            output.println("Other");
        } else {
            output.println(fileName);
        }
    }

    protected void printByChangeSet(PrintWriter output, List<ReportItem> items) {
        items.stream().collect(Collectors.groupingBy(item -> Optional.ofNullable(item.getChangeSetId()).map(String::trim).orElse(""))).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> this.printChangeSet(output, (String)entry.getKey(), (List)entry.getValue()));
    }

    protected void printChangeSet(PrintWriter output, String changeSetId, List<ReportItem> items) {
        this.printChangeSetHeader(output, changeSetId);
        this.printByItemType(output, items);
    }

    protected void printChangeSetHeader(PrintWriter output, String changeSetId) {
        if (!changeSetId.isEmpty()) {
            output.append("changeSet '").append(changeSetId).append("'").println();
        }
    }

    protected void printByItemType(PrintWriter output, List<ReportItem> items) {
        items.stream().collect(Collectors.groupingBy(ReportItem::getType)).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> this.printItemType(output, (ReportItem.ReportItemType)((Object)((Object)entry.getKey())), (List)entry.getValue()));
    }

    protected void printItemType(PrintWriter output, ReportItem.ReportItemType type, List<ReportItem> items) {
        this.printItemTypeHeader(output, type);
        items.forEach(item -> this.printItemDetail(output, (ReportItem)item));
    }

    protected void printItemTypeHeader(PrintWriter output, ReportItem.ReportItemType type) {
        output.println(type.name());
    }

    protected void printItemDetail(PrintWriter output, ReportItem item) {
        output.append("\t'").append(item.getRule()).append("': ").println(this.indentMessage(item.getMessage()));
    }

    protected String indentMessage(String message) {
        return message.replace("\n", "\n\t\t");
    }

    protected void printSummary(PrintWriter output, Report report) {
        this.printSummaryHeader(output, report);
        this.printSummaryByItemType(output, report.getItems());
        this.printSummaryDisabledRules(output, report);
    }

    protected void printSummaryHeader(PrintWriter output, Report report) {
        output.println("Summary:");
    }

    protected void printSummaryByItemType(PrintWriter output, List<ReportItem> items) {
        for (ReportItem.ReportItemType type : ReportItem.ReportItemType.values()) {
            this.printItemTypeSummary(output, type, items.stream().filter(item -> item.getType() == type).collect(Collectors.toList()));
        }
    }

    protected void printItemTypeSummary(PrintWriter output, ReportItem.ReportItemType type, List<ReportItem> items) {
        output.append('\t').append(type.name()).append(": ").println(items.size());
    }

    protected void printSummaryDisabledRules(PrintWriter output, Report report) {
        output.append("\tDISABLED: ").println(TextReporter.countDisabledRules(report));
    }

    @AutoService(value={Reporter.Factory.class})
    public static class Factory
    extends AbstractReporter.Factory<TextReporter> {
        public Factory() {
            super(TextReporter.NAME);
        }
    }
}

