/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.rules.core;

import com.google.auto.service.AutoService;
import io.github.liquibaselinter.config.RuleConfig;
import io.github.liquibaselinter.rules.ChangeRule;
import io.github.liquibaselinter.rules.LintRuleViolationGenerator;
import io.github.liquibaselinter.rules.RuleViolation;
import java.util.Collection;
import java.util.Collections;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;

@AutoService(value={ChangeRule.class})
public class IllegalChangeTypesRule
implements ChangeRule {
    private static final String NAME = "illegal-change-types";
    private static final String DEFAULT_MESSAGE = "Change type '%s' is not allowed in this project";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Collection<RuleViolation> check(Change change, RuleConfig ruleConfig) {
        if (ruleConfig.getValues() == null) {
            return Collections.emptyList();
        }
        boolean changeIsNotAllowed = ruleConfig.getValues().stream().anyMatch(illegal -> IllegalChangeTypesRule.getChangeName(change).equals(illegal) || IllegalChangeTypesRule.getChangeClassName(change).equals(illegal));
        if (changeIsNotAllowed) {
            LintRuleViolationGenerator violations = new LintRuleViolationGenerator(DEFAULT_MESSAGE, ruleConfig);
            return Collections.singleton(violations.withFormattedMessage(change.getClass().getCanonicalName()));
        }
        return Collections.emptyList();
    }

    private static String getChangeClassName(Change change) {
        return change.getClass().getName();
    }

    private static String getChangeName(Change change) {
        return change.getClass().getAnnotation(DatabaseChange.class).name();
    }
}

