/*
 * Decompiled with CFR 0.152.
 */
package io.github.liquibaselinter.rules.core;

import com.google.auto.service.AutoService;
import io.github.liquibaselinter.config.RuleConfig;
import io.github.liquibaselinter.rules.ChangeLogRule;
import io.github.liquibaselinter.rules.ChangeSetRule;
import io.github.liquibaselinter.rules.LintRuleViolationGenerator;
import io.github.liquibaselinter.rules.RuleViolation;
import java.util.Collection;
import java.util.Collections;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.precondition.core.PreconditionContainer;

@AutoService(value={ChangeLogRule.class, ChangeSetRule.class})
public class NoPreconditionsRule
implements ChangeSetRule,
ChangeLogRule {
    private static final String NAME = "no-preconditions";
    private static final String DEFAULT_MESSAGE = "Preconditions are not allowed in this project";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Collection<RuleViolation> check(DatabaseChangeLog changeLog, RuleConfig ruleConfig) {
        if (this.isInvalid(changeLog)) {
            LintRuleViolationGenerator violations = new LintRuleViolationGenerator(DEFAULT_MESSAGE, ruleConfig);
            return Collections.singleton(violations.withFormattedMessage(new Object[0]));
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<RuleViolation> check(ChangeSet changeSet, RuleConfig ruleConfig) {
        if (changeSet.getPreconditions() != null && !changeSet.getPreconditions().getNestedPreconditions().isEmpty()) {
            LintRuleViolationGenerator violations = new LintRuleViolationGenerator(DEFAULT_MESSAGE, ruleConfig);
            return Collections.singleton(violations.withFormattedMessage(new Object[0]));
        }
        return Collections.emptyList();
    }

    public boolean isInvalid(DatabaseChangeLog changeLog) {
        return NoPreconditionsRule.isInvalid(changeLog.getPreconditions());
    }

    private static boolean isInvalid(PreconditionContainer preconditions) {
        if (preconditions == null || preconditions.getNestedPreconditions().isEmpty()) {
            return false;
        }
        if (preconditions.getNestedPreconditions().stream().anyMatch(precondition -> !(precondition instanceof PreconditionContainer))) {
            return true;
        }
        return preconditions.getNestedPreconditions().stream().map(PreconditionContainer.class::cast).anyMatch(NoPreconditionsRule::isInvalid);
    }
}

